/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.sort;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.Objects;

public class Sort {
    private static final Sort NO_SORT = new Sort(true);
    private IEntityField field;
    private boolean asc;
    private boolean outOfOrder;

    public static Sort buildAscSort(IEntityField field) {
        return new Sort(field, true);
    }

    public static Sort buildDescSort(IEntityField field) {
        return new Sort(field, false);
    }

    public static Sort buildOutOfSort() {
        return NO_SORT;
    }

    private Sort(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    private Sort(IEntityField field, boolean asc) {
        this.field = field;
        this.asc = asc;
    }

    public IEntityField getField() {
        return this.field;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public boolean isDes() {
        return !this.asc;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)o;
        return this.isAsc() == sort.isAsc() && this.isOutOfOrder() == sort.isOutOfOrder() && Objects.equals(this.getField(), sort.getField());
    }

    public int hashCode() {
        return Objects.hash(this.getField(), this.isAsc(), this.isOutOfOrder());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Sort{");
        sb.append("field=").append(this.field);
        sb.append(", asc=").append(this.asc);
        sb.append(", outOfOrder=").append(this.outOfOrder);
        sb.append('}');
        return sb.toString();
    }
}

