/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.engine;

import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntityClassGroup
implements EntityClassGroup {
    private static final Logger log = LoggerFactory.getLogger(DefaultEntityClassGroup.class);
    private EntityClassEngine engine;
    private IEntityClass mainEntityClass;
    private List<IEntityClass> fatherEntityClass;
    private List<IEntityClass> childrenEntityClass;
    private String profile;

    public DefaultEntityClassGroup(EntityClassEngine engine, IEntityClass mainEntityClass, List<IEntityClass> fatherEntityClass, List<IEntityClass> childrenEntityClass, String profile) {
        this.engine = engine;
        this.mainEntityClass = mainEntityClass;
        this.fatherEntityClass = fatherEntityClass;
        this.childrenEntityClass = childrenEntityClass;
        this.profile = profile;
    }

    public List<IEntityClass> getFatherEntityClass() {
        return Collections.unmodifiableList(this.fatherEntityClass);
    }

    public List<IEntityClass> getChildrenEntityClass() {
        return Collections.unmodifiableList(this.childrenEntityClass);
    }

    private Set<String> getAllKeys() {
        return this.getAllFields().stream().map(IEntityField::name).collect(Collectors.toSet());
    }

    public List<IRelation> getAllRelations() {
        LinkedList<IRelation> allRelation = new LinkedList<IRelation>(this.mainEntityClass.relations());
        this.fatherEntityClass.stream().flatMap(x -> x.relations().stream()).forEach(allRelation::add);
        return allRelation;
    }

    public List<IEntityField> getAllFields() {
        LinkedList<IEntityField> allFields = new LinkedList<IEntityField>(this.mainEntityClass.fields());
        this.fatherEntityClass.stream().flatMap(x -> x.fields().stream()).forEach(allFields::add);
        return allFields;
    }

    @Override
    public Optional<IEntityField> field(String rawCode) {
        Optional<IEntityField> field = this.mainEntityClass.field(rawCode);
        if (!field.isPresent()) {
            return this.fatherEntityClass.stream().map(x -> x.field(rawCode)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        return field;
    }

    @Override
    public Optional<IEntityField> field(long fieldId) {
        Optional<IEntityField> field = this.mainEntityClass.field(fieldId);
        if (!field.isPresent()) {
            return this.fatherEntityClass.stream().map(x -> x.field(fieldId)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        return field;
    }

    @Override
    public Optional<IRelation> relation(long relationId) {
        Optional<IRelation> first = this.mainEntityClass.relations().stream().filter(x -> x.getId() == relationId).findFirst();
        if (!first.isPresent()) {
            return this.fatherEntityClass.stream().flatMap(x -> x.relations().stream()).filter(x -> x.getId() == relationId).findFirst();
        }
        return first;
    }

    @Override
    public Optional<IRelation> relation(String relationCode) {
        Optional<IRelation> first = this.mainEntityClass.relations().stream().filter(x -> x.getName().equalsIgnoreCase(relationCode)).findFirst();
        if (!first.isPresent()) {
            return this.fatherEntityClass.stream().flatMap(x -> x.relations().stream()).filter(x -> x.getName().equalsIgnoreCase(relationCode)).findFirst();
        }
        return first;
    }

    @Override
    public Optional<IEntityClass> relatedEntityClass(String relatedCode) {
        Optional<IRelation> first = this.mainEntityClass.relations().stream().filter(x -> x.getRelOwnerClassId() == this.mainEntityClass.id()).filter(x -> x.getName().equals(relatedCode)).findFirst();
        if (first.isPresent()) {
            return this.engine.load(String.valueOf(first.get().getEntityClassId()), this.profile);
        }
        Optional<IRelation> relationInParent = this.fatherEntityClass.stream().map(x -> x.relations().stream().filter(rel -> rel.getRelOwnerClassId() == x.id()).filter(rel -> rel.getName().equals(relatedCode)).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst();
        return relationInParent.flatMap(x -> this.engine.load(String.valueOf(x.getEntityClassId()), this.profile));
    }

    @Override
    public Set<String> testBody(Map<String, Object> map, long targetId) {
        Set<String> inputKeys = map.keySet();
        Set<String> allKeys = this.getAllKeys();
        return inputKeys.stream().filter(x -> !allKeys.contains(x)).collect(Collectors.toSet());
    }

    @Override
    public IEntityClass getEntityClass() {
        return this.mainEntityClass;
    }

    @Override
    public String profile() {
        return this.profile;
    }

    @Override
    public String realProfile() {
        return this.profile;
    }

    @Override
    public EntityClassGroup relatedEntityClassWithRawName(String rawName) {
        return null;
    }

    @Override
    public EntityClassEngine classEngine() {
        return this.engine;
    }

    @Override
    public Record toRecordNew(Map<Tuple2<String, Long>, Object> body, long entityClassId) {
        Collection<Object> fieldsList = Collections.emptyList();
        if (this.mainEntityClass.id() == entityClassId || entityClassId == 0L) {
            IEntityClass targetClass = this.mainEntityClass;
            fieldsList = this.getAllFields();
        } else {
            Optional<IEntityClass> targetOp = this.fatherEntityClass.stream().filter(x -> x.id() == entityClassId).findFirst();
            if (targetOp.isPresent()) {
                IEntityClass targetClass = targetOp.get();
                fieldsList = this.engine.describe(targetClass, this.profile).getAllFields();
            } else {
                targetOp = this.childrenEntityClass.stream().filter(x -> x.id() == entityClassId).findFirst();
                if (targetOp.isPresent()) {
                    IEntityClass targetClass = targetOp.get();
                    fieldsList = this.engine.describe(targetClass, this.profile).getAllFields();
                }
            }
        }
        GeneralRecord record = new GeneralRecord(fieldsList, 0);
        record.setTypeId(entityClassId);
        fieldsList.forEach(x -> record.set((IEntityField)x, body.get(Tuple.of((Object)x.name(), (Object)x.id()))));
        Object id = body.get("id");
        if (id != null) {
            record.setId((Long)id);
        }
        return record;
    }

    @Override
    public Optional<ColumnField> column(String fieldCode) {
        return this.engine.column(this.getEntityClass(), ResourcePath.parse("@".concat(this.mainEntityClass.code()).concat("#").concat(fieldCode)), this.profile);
    }

    @Override
    public List<ColumnField> columns(String fieldCode) {
        return this.engine.columns(this.getEntityClass(), ResourcePath.parse("@".concat(this.mainEntityClass.code()).concat("#").concat(fieldCode)), this.profile);
    }

    @Override
    public List<ColumnField> columns() {
        Stream<ColumnField> mainFields = this.mainEntityClass.fields().stream().map(x -> new ColumnField(x.name(), (IEntityField)x, this.mainEntityClass));
        Stream fatherFields = this.fatherEntityClass.stream().flatMap(x -> x.fields().stream().map(field -> new ColumnField(x.name(), (IEntityField)field, (IEntityClass)x)));
        return Stream.concat(mainFields, fatherFields).collect(Collectors.toList());
    }

    @Override
    public String getJoinTable(String tableName) {
        return tableName;
    }

    @Override
    public Collection<Tuple2<String, String>> getAllToOneReverseRelations() {
        return Collections.emptyList();
    }
}

