/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.impl;

import com.xforceplus.metadata.schema.dsl.bo.__;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.ultraman.metadata.entity.CalculationType;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.calculation.Formula;
import com.xforceplus.ultraman.metadata.entity.calculation.Lookup;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

public class LazyField
implements IEntityField,
Refreshable {
    private MetadataEngine engine;
    private BoField boField;
    private com.xforceplus.metadata.schema.typed.FieldType fieldType;
    private String dictId;
    private FieldConfig fieldConfig;

    public LazyField(BoField boField, MetadataEngine engine) {
        this.boField = boField;
        this.engine = engine;
        this.type();
        this.config();
    }

    @Override
    public long id() {
        return Long.parseLong(this.boField.getId());
    }

    @Override
    public String name() {
        return this.boField.getCode();
    }

    @Override
    public String cnName() {
        return this.boField.getName();
    }

    @Override
    public FieldType type() {
        if (this.fieldType == null) {
            if (this.boField.getFieldType() != null) {
                this.fieldType = this.boField.getFieldType();
            } else {
                Optional typeOp = this.engine.get((GraphTraversal)__.has((String)"_id", (Object)this.boField.getId()).out(new String[]{MetadataRelationType.HAS_TYPE.name()}));
                if (typeOp.isPresent()) {
                    Map map = (Map)typeOp.get();
                    com.xforceplus.metadata.schema.typed.FieldType fieldType = new com.xforceplus.metadata.schema.typed.FieldType();
                    fieldType.from(map);
                    this.fieldType = fieldType;
                } else {
                    com.xforceplus.metadata.schema.typed.FieldType fieldType = new com.xforceplus.metadata.schema.typed.FieldType();
                    fieldType.setValueType("Long");
                    this.fieldType = fieldType;
                }
            }
        }
        return this.fromFieldType(this.fieldType);
    }

    private FieldType fromFieldType(com.xforceplus.metadata.schema.typed.FieldType fieldType) {
        if (fieldType == null) {
            return FieldType.STRING;
        }
        String valueType = fieldType.getValueType();
        return FieldType.fromRawType(valueType);
    }

    @Override
    public FieldConfig config() {
        if (this.fieldConfig == null) {
            Optional extraOp = this.engine.get((GraphTraversal)__.has((String)"_id", (Object)this.boField.getId()).out(new String[]{MetadataRelationType.HAS_CONFIG.name()}));
            FieldConfig config = new FieldConfig();
            if (extraOp.isPresent()) {
                Map map = (Map)extraOp.get();
                Object isEditable = map.get("isEditable");
                Object isRequired = map.get("isRequired");
                Object isSearchable = map.get("isSearchable");
                Object length = map.get("length");
                Object decimalPoint = map.get("decimalPoint");
                Optional calOp = this.engine.get((GraphTraversal)__.has((String)"_id", (Object)this.boField.getId()).out(new String[]{MetadataRelationType.HAS_CAL.name()}));
                if (calOp.isPresent()) {
                    Map calMap = (Map)calOp.get();
                    Object refBoId = calMap.get("refBoId");
                    Object refFieldId = calMap.get("refFieldId");
                    Object refRelId = calMap.get("refRelId");
                    Object formulaContent = calMap.get("formulaContent");
                    if (refBoId != null) {
                        config.calculateType(CalculationType.LOOKUP.getSymbol()).resetCalculation(Lookup.Builder.anLookup().withClassId(Long.parseLong(refBoId.toString())).withFieldId(Long.parseLong(refFieldId.toString())).withRelationId(Long.parseLong(refRelId.toString())).build());
                    } else if (formulaContent != null) {
                        config.calculateType(CalculationType.FORMULA.getSymbol()).resetCalculation(Formula.Builder.anFormula().withExpression(formulaContent.toString()).withLevel(0).withFailedPolicy(Formula.FailedPolicy.UNKNOWN).withFailedDefaultValue(null).build());
                    }
                }
                this.fieldConfig = config.searchable(Optional.ofNullable(isSearchable).map(x -> (Boolean)x).orElse(false)).fieldSense(FieldConfig.FieldSense.NORMAL).isEditable(Optional.ofNullable(isEditable).map(x -> (Boolean)x).orElse(true)).required(Optional.ofNullable(isRequired).map(x -> (Boolean)x).orElse(false)).precision(Optional.ofNullable(decimalPoint).map(x -> (Integer)x).orElse(0)).length(Optional.ofNullable(length).map(x -> (Integer)x).orElse(1000)).isSystem(false);
            } else {
                this.fieldConfig = config.calculateType(CalculationType.STATIC.getSymbol()).searchable(true).fieldSense(FieldConfig.FieldSense.NORMAL).isEditable(true).required(false).precision(0).length(20);
            }
            if (this.boField.getCode().equals("id")) {
                this.fieldConfig.isSystem(true).identifie(true);
            }
        }
        return this.fieldConfig;
    }

    @Override
    public String dictId() {
        if (this.dictId == null) {
            this.dictId = this.fieldType.getDictId();
        }
        return this.dictId;
    }

    @Override
    public String defaultValue() {
        return this.boField.getDefaultValue();
    }

    @Override
    public IEntityField clone() {
        return new LazyField(this.boField, this.engine);
    }

    @Override
    public boolean isDynamic() {
        return Optional.ofNullable(this.boField.getDynamic()).orElse(false);
    }

    @Override
    public CalculationType calculationType() {
        return null;
    }

    @Override
    public String realProfile() {
        return this.boField.getProfile();
    }

    public void onRefresh(Object payload) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyField lazyField = (LazyField)o;
        return Objects.equals(this.boField, lazyField.boField);
    }

    public int hashCode() {
        return Objects.hash(this.boField);
    }

    public String toString() {
        return "LazyField{boField=" + this.boField + ", fieldType=" + this.fieldType + ", dictId='" + this.dictId + '\'' + ", fieldConfig=" + this.fieldConfig + '}';
    }
}

