package com.xforceplus.ultraman.metadata.domain.vo;

import io.vavr.Tuple2;

import java.util.Collections;
import java.util.List;

/**
 * @param <T>
 */
public class DataCollection<T> {

    private Integer rowNum;

    private List<T> rows;

    public DataCollection(Integer rowNum, List<T> rows) {
        this.rowNum = rowNum;
        this.rows = rows;
    }

    public Integer getRowNum() {
        return rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public List<T> getRows() {
        return rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public static <T> DataCollection<T> from(Tuple2<Integer, List<T>> items){
       return new DataCollection<>(items._1(), items._2());
    }

    public static <T> DataCollection<T> empty(){
        return new DataCollection<>(0, Collections.emptyList());
    }

    @Override
    public String toString() {
        return "DataCollection{" +
                "rowNum=" + rowNum +
                ", rows=" + rows +
                '}';
    }
}
