package com.xforceplus.ultraman.metadata.entity.impl;

import com.xforceplus.metadata.schema.dsl.bo.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.ultraman.metadata.entity.CalculationType;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.calculation.Formula;
import com.xforceplus.ultraman.metadata.entity.calculation.Lookup;
import com.xforceplus.ultraman.sdk.infra.Refreshable;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import static com.xforceplus.metadata.schema.rels.MetadataRelationType.*;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.ID_INDEX;

public class LazyField implements IEntityField, Refreshable {

    private MetadataEngine engine;

    private BoField boField;

    private com.xforceplus.metadata.schema.typed.FieldType fieldType;

    private String dictId;

    private FieldConfig fieldConfig;

    public LazyField(BoField boField, MetadataEngine engine) {
        this.boField = boField;
        this.engine = engine;
        type();
        config();
    }

    @Override
    public long id() {
        return Long.parseLong(boField.getId());
    }

    @Override
    public String name() {
        return boField.getCode();
    }

    @Override
    public String cnName() {
        return boField.getName();
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public FieldType type() {
        if (fieldType == null) {
            
            if(boField.getFieldType() != null) {
                this.fieldType = boField.getFieldType();
            } else {

                Optional<Map<String, Object>> typeOp = engine.get(__.has(ID_INDEX, boField.getId())
                        .out(HAS_TYPE.name()));
                if (typeOp.isPresent()) {
                    Map<String, Object> map = typeOp.get();
                    com.xforceplus.metadata.schema.typed.FieldType fieldType = new com.xforceplus.metadata.schema.typed.FieldType();
                    fieldType.from(map);
                    this.fieldType = fieldType;
                } else {
                    //is a generated field
                    com.xforceplus.metadata.schema.typed.FieldType fieldType = new com.xforceplus.metadata.schema.typed.FieldType();
                    fieldType.setValueType("Long");
                    this.fieldType = fieldType;
                }
            }
        }

        return fromFieldType(fieldType);
    }

    private FieldType fromFieldType(com.xforceplus.metadata.schema.typed.FieldType fieldType) {
        if (fieldType == null) {
            return FieldType.STRING;
        } else {
            String valueType = fieldType.getValueType();
            return FieldType.fromRawType(valueType);
        }
    }

    @Override
    public FieldConfig config() {
        if (fieldConfig == null) {
            //query the extra
            Optional<Map<String, Object>> extraOp = engine.get(__.has(ID_INDEX, boField.getId())
                    .out(HAS_CONFIG.name()));

            //{"id":4152,"label":"ExtraConfig","isEditable":false,"isRequired":false,"isSearchable":true,"length":200,"nodeLabel":"ExtraConfig"}
            FieldConfig config = new FieldConfig();
            if (extraOp.isPresent()) {
                Map<String, Object> map = extraOp.get();
                Object isEditable = map.get("isEditable");
                Object isRequired = map.get("isRequired");
                Object isSearchable = map.get("isSearchable");
                Object length = map.get("length");
                Object decimalPoint = map.get("decimalPoint");

                Optional<Map<String, Object>> calOp = engine.get(__.has(ID_INDEX, boField.getId())
                        .out(HAS_CAL.name()));
                
                if(calOp.isPresent()) {
                    Map<String, Object> calMap = calOp.get();
                    Object refBoId = calMap.get("refBoId");
                    Object refFieldId = calMap.get("refFieldId");
                    Object refRelId = calMap.get("refRelId");
                    Object formulaContent = calMap.get("formulaContent");
                    
                    if(refBoId != null) {
                        config.calculateType(CalculationType.LOOKUP.getSymbol())
                                .resetCalculation(Lookup.Builder.anLookup()
                                        .withClassId(Long.parseLong(refBoId.toString()))
                                        .withFieldId(Long.parseLong(refFieldId.toString()))
                                        .withRelationId(Long.parseLong(refRelId.toString()))
                                        .build());
                        
                    } else if (formulaContent != null) {
                        config.calculateType(CalculationType.FORMULA.getSymbol())
                                .resetCalculation(Formula.Builder.anFormula()
                                        .withExpression(formulaContent.toString())
                                        .withLevel(0)
                                        .withFailedPolicy(Formula.FailedPolicy.UNKNOWN)
                                        .withFailedDefaultValue(null)
                                        .build());
                    }
                }

                this.fieldConfig = config
                        .searchable(Optional.ofNullable(isSearchable).map(x -> (Boolean) x).orElse(false))
                        .fieldSense(FieldConfig.FieldSense.NORMAL)
                        .isEditable(Optional.ofNullable(isEditable).map(x -> (Boolean) x).orElse(true))
                        .required(Optional.ofNullable(isRequired).map(x -> (Boolean) x).orElse(false))
                        .precision(Optional.ofNullable(decimalPoint).map(x -> (Integer) x).orElse(0))
                        .length(Optional.ofNullable(length).map(x -> (Integer) x).orElse(1000))
                        .isSystem(false);
            } else {
                this.fieldConfig = config.calculateType(CalculationType.STATIC.getSymbol())
                        .searchable(true)
                        .fieldSense(FieldConfig.FieldSense.NORMAL)
                        .isEditable(true)
                        .required(false)
                        .precision(0)
                        .length(20);
            }

            if (boField.getCode().equals("id")) {
                fieldConfig.isSystem(true).identifie(true);
            }
        }
        return fieldConfig;
    }

    //TODO
    @Override
    public String dictId() {
//        if (type() == FieldType.ENUM || type() == FieldType.STRINGS) {
        if (dictId == null) {
            dictId = fieldType.getDictId();
        }
        return dictId;
//        } else {
//            return null;
//        }
    }

    //TODO
    @Override
    public String defaultValue() {
        return boField.getDefaultValue();
    }

    //TODO
    @Override
    public IEntityField clone() {
        return new LazyField(this.boField, engine);
    }

    //TODO
    @Override
    public boolean isDynamic() {
        return Optional.ofNullable(boField.getDynamic()).orElse(false);
    }

    //TODO
    @Override
    public CalculationType calculationType() {
        return null;
    }

    @Override
    public String realProfile() {
        return boField.getProfile();
    }

    @Override
    public void onRefresh(Object payload) {

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LazyField lazyField = (LazyField) o;
        return Objects.equals(boField, lazyField.boField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(boField);
    }

    @Override
    public String toString() {
        return "LazyField{" +
                "boField=" + boField +
                ", fieldType=" + fieldType +
                ", dictId='" + dictId + '\'' +
                ", fieldConfig=" + fieldConfig +
                '}';
    }
}
