package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.domain.func.DynamicHelper;
import com.xforceplus.ultraman.metadata.domain.func.FuncValue;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.exceptions.OperationNotSupportedException;

import java.util.Optional;

public class ExpressionValue extends AbstractValue<FuncValue> {

    public ExpressionValue(IEntityField field, FuncValue value) {
        super(field, value);
    }

    @Override
    public long valueToLong() {
        return 0;
    }

    @Override
    protected IValue<FuncValue> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        return new ExpressionValue(newField, getValue());
    }

    @Override
    protected IValue<FuncValue> doCopy(FuncValue value) {
        return new ExpressionValue(getField(), value);
    }

    @Override
    FuncValue fromString(String value) {
        throw new OperationNotSupportedException(OperationNotSupportedException.getMsg("From String" + value));
    }

    @Override
    public Object storageValue() {
        if(getField().isDynamic()) {
            return Optional.ofNullable(getValue()).map(x -> {
                return DynamicHelper.dynamicPattern(getField().name(), x.funcExpression());          
            }).orElse(null);
        } else {
            return Optional.ofNullable(getValue()).map(FuncValue::funcExpression).orElse(null);
        }
    }
}
