package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.Operation;

public class OnDuplicateValue extends AbstractValue<IValue> {
    
    private IValue onDuplicate;
    
    private IValue current;
    
    public OnDuplicateValue(IEntityField field, IValue current, IValue duplicateValue) {
        super(field, current);
        this.onDuplicate = duplicateValue;
    }

    @Override
    public long valueToLong() {
        return getValue().valueToLong();
    }

    @Override
    public Object storageValue() {
        return  getValue().storageValue();
    }

    @Override
    public Object storageValue(Operation operation) {
        if(operation == Operation.REPLACE) {
            return  onDuplicate.storageValue();
        } else {
            return storageValue();
        }
    }

    @Override
    protected IValue<IValue> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        return null;
    }

    @Override
    protected IValue<IValue> doCopy(IValue value) {
        return null;
    }

    @Override
    IValue fromString(String value) {
        return null;
    }
}
