package com.xforceplus.ultraman.metadata.domain.func;

import com.xforceplus.ultraman.metadata.entity.FieldType;

import java.math.BigDecimal;

public abstract class BiNumFuncValue implements FuncValue {

    private final String key;

    private final Number num;

    private final String expression = "`%s` %s '%s'";

//    private final String dynamicExpression = "JSON_SET(_sys_dynamic, '$.%s', JSON_EXTRACT(_sys_dynamic, '$.%s') %s '%s')";
    
    abstract String getOperator();

    public BiNumFuncValue(String key, Number num) {
        this.key = key;
        this.num = num;
    }

    private String numberToString() {
        if(num instanceof BigDecimal) {
            return ((BigDecimal) num).toPlainString();
        } else {
            return num.toString();
        }
    }

    @Override
    public String funcExpression() {
        return String.format(expression, key, getOperator(), numberToString());
    }

    @Override
    public FieldType type() {
        if(num instanceof BigDecimal) {
            return FieldType.DECIMAL;
        } else {
            return FieldType.LONG;
        }
    }
}
