package com.xforceplus.ultraman.metadata.domain.func;

import com.xforceplus.ultraman.metadata.entity.FieldType;

import java.util.Arrays;
import java.util.stream.Collectors;

public class Concat implements FuncValue {
    
    private final FuncTyped[] funcTypedList;
    
    private String CONCAT_STR = "CONCAT(%s)";
    
    public Concat(FuncTyped...funcTypedList) {
        this.funcTypedList = funcTypedList;
    }

    @Override
    public String funcName() {
        return "Concat";
    }

    /**
     * JSON_SET(_sys_dynamic, '$.abc', CONCAT(JSON_UNQUOTE(JSON_EXTRACT(_sys_dynamic, '$.abc')), 'abc'))
     * @return
     */
    @Override
    public String funcExpression() {
        String concat = Arrays.asList(funcTypedList)
                .stream()
                .map(FuncTyped::getValue)
                .collect(Collectors.joining(","));
        return String.format(CONCAT_STR, concat);
    }
    
    @Override
    public FieldType type() {
        return FieldType.STRING;
    }
}
