package com.xforceplus.ultraman.metadata.domain.vo.dto;


import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 业务对象查询结果
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-28
 */
public class BoInfoVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 业务对象ID
     */
    private Long id;
    /**
     * 业务对象编码
     */
    private String code;
    /**
     * 业务对象名称
     */
    private String name;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 租户代码
     */
    private String tenantCode;
    /**
     * 租户名称
     */
    private String tenantName;
    /**
     * 模块Id
     */
    private Long moduleId;
    /**
     * 类型
     */
    private String boType;

    /**
     * 创建方式
     */
    private String createType;

    /**
     * 父对象Id
     */
    private Long parentBoId;

    /**
     * 系统类型
     */
    private String sysType;
    /**
     * 持久化信息
     */
    private String persistence;

    /**
     * 说明信息
     */
    private String remark;

    /**
     * 版本
     */
    private String version;
    /**
     * 根boId
     */
    private Long publishBoId;
    /**
     * 业务对象Api信息
     */
    private List<BoApiVo> apis;
    /**
     * 业务对象字段信息
     */
    private List<BoFieldVo> fields;
    /**
     * 子对象的ID集合
     */
    private List<RelationshipVo> relationshipVos;

    private String domainCode;

    private String domainName;

    private Long domainRootId;

    private String rootFlag;

    private String profile;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public Long getDomainRootId() {
        return domainRootId;
    }

    public void setDomainRootId(Long domainRootId) {
        this.domainRootId = domainRootId;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public String getBoType() {
        return boType;
    }

    public void setBoType(String boType) {
        this.boType = boType;
    }

    public String getCreateType() {
        return createType;
    }

    public void setCreateType(String createType) {
        this.createType = createType;
    }

    public Long getParentBoId() {
        return parentBoId;
    }

    public void setParentBoId(Long parentBoId) {
        this.parentBoId = parentBoId;
    }

    public String getSysType() {
        return sysType;
    }

    public void setSysType(String sysType) {
        this.sysType = sysType;
    }

    public String getPersistence() {
        return persistence;
    }

    public void setPersistence(String persistence) {
        this.persistence = persistence;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Long getPublishBoId() {
        return publishBoId;
    }

    public void setPublishBoId(Long publishBoId) {
        this.publishBoId = publishBoId;
    }

    public List<BoApiVo> getApis() {
        return apis;
    }

    public void setApis(List<BoApiVo> apis) {
        this.apis = apis;
    }

    public List<BoFieldVo> getFields() {
        return fields;
    }

    public void setFields(List<BoFieldVo> fields) {
        this.fields = fields;
    }

    public List<RelationshipVo> getRelationshipVos() {
        return relationshipVos;
    }

    public void setRelationshipVos(List<RelationshipVo> relationshipVos) {
        this.relationshipVos = relationshipVos;
    }

    public String getRootFlag() {
        return rootFlag;
    }

    public void setRootFlag(String rootFlag) {
        this.rootFlag = rootFlag;
    }

    public String getProfile() {
        return profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof BoInfoVo)) return false;
        BoInfoVo boInfoVo = (BoInfoVo) o;
        return Objects.equals(getId(), boInfoVo.getId()) &&
                Objects.equals(getCode(), boInfoVo.getCode()) &&
                Objects.equals(getName(), boInfoVo.getName()) &&
                Objects.equals(getTenantId(), boInfoVo.getTenantId()) &&
                Objects.equals(getTenantCode(), boInfoVo.getTenantCode()) &&
                Objects.equals(getTenantName(), boInfoVo.getTenantName()) &&
                Objects.equals(getModuleId(), boInfoVo.getModuleId()) &&
                Objects.equals(getBoType(), boInfoVo.getBoType()) &&
                Objects.equals(getCreateType(), boInfoVo.getCreateType()) &&
                Objects.equals(getParentBoId(), boInfoVo.getParentBoId()) &&
                Objects.equals(getSysType(), boInfoVo.getSysType()) &&
                Objects.equals(getPersistence(), boInfoVo.getPersistence()) &&
                Objects.equals(getRemark(), boInfoVo.getRemark()) &&
                Objects.equals(getVersion(), boInfoVo.getVersion()) &&
                Objects.equals(getPublishBoId(), boInfoVo.getPublishBoId()) &&
                Objects.equals(getApis(), boInfoVo.getApis()) &&
                Objects.equals(getFields(), boInfoVo.getFields()) &&
                Objects.equals(getRelationshipVos(), boInfoVo.getRelationshipVos()) &&
                Objects.equals(getDomainCode(), boInfoVo.getDomainCode()) &&
                Objects.equals(getDomainName(), boInfoVo.getDomainName()) &&
                Objects.equals(getDomainRootId(), boInfoVo.getDomainRootId()) &&
                Objects.equals(getRootFlag(), boInfoVo.getRootFlag());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getCode(), getName(), getTenantId(), getTenantCode(), getTenantName(), getModuleId(), getBoType(), getCreateType(), getParentBoId(), getSysType(), getPersistence(), getRemark(), getVersion(), getPublishBoId(), getApis(), getFields(), getRelationshipVos(), getDomainCode(), getDomainName(), getDomainRootId(), getRootFlag());
    }

    @Override
    public String toString() {
        return "BoInfoVo{" +
                "id=" + id +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", tenantId=" + tenantId +
                ", tenantCode='" + tenantCode + '\'' +
                ", tenantName='" + tenantName + '\'' +
                ", moduleId=" + moduleId +
                ", boType='" + boType + '\'' +
                ", createType='" + createType + '\'' +
                ", parentBoId=" + parentBoId +
                ", sysType='" + sysType + '\'' +
                ", persistence='" + persistence + '\'' +
                ", remark='" + remark + '\'' +
                ", version='" + version + '\'' +
                ", publishBoId=" + publishBoId +
                ", apis=" + apis +
                ", fields=" + fields +
                ", relationshipVos=" + relationshipVos +
                ", domainCode='" + domainCode + '\'' +
                ", domainName='" + domainName + '\'' +
                ", domainRootId=" + domainRootId +
                ", rootFlag='" + rootFlag + '\'' +
                '}';
    }
}
