package com.xforceplus.ultraman.metadata.cdc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import java.util.*;

/**
 * Created by justin.xu on 05/2023.
 *
 * @since 1.8
 */
public class OqsEngineEntity implements Cloneable {

  private boolean deleted;
  private int version;
  private long id;
  private long updateTime;
  private long father;
  private long maintainId;
  private String routingId;
  // 实例原始属性.
  private Map<String, Object> attributes;
  private EntityClassRef entityClassRef;

  /**
   * code, tenantCode, relatedCode ,id
   */
  private List<Tuple4<String, String, String, Tuple2<Long, Map<String, Object>>>> toOneRelatedList = new ArrayList<>();

  /**
   * 实例.
   */
  public OqsEngineEntity() {
    father = 0;
    deleted = false;
    version = 0;
    id = 0;
    updateTime = 0;
  }

  public static Map<String, Object> addDynamicAttrWithNullValue(IEntityClass entityClass, String attrStr) throws JsonProcessingException {
    final Map<String, Object> result;

    if (attrStr.isEmpty()) {
      result = new HashMap<>();
    } else {
      result = attributesToMap(attrStr);
    }

    entityClass.selfFields().stream().filter(IEntityField::isDynamic).forEach(f -> {
      if (!result.containsKey(f.name())) {
        result.put(f.name(), null);
      } else if (f.type().equals(FieldType.BOOLEAN)) {
        result.computeIfPresent(f.name(), (k, s) -> {
          return ((int) s) != 0;
        });

      }
    });

    return result;
  }

  public static Map<String, Object> attributesToMap(String attrStr) throws JsonProcessingException {
    return JacksonDefaultMapper.OBJECT_MAPPER.readValue(attrStr, Map.class);
  }

  public long getFather() {
    return father;
  }

  public void setFather(long father) {
    this.father = father;
  }

  public boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(boolean deleted) {
    this.deleted = deleted;
  }

  public int getVersion() {
    return version;
  }

  public void setVersion(int version) {
    this.version = version;
  }

  public long getId() {
    return id;
  }

  public void setId(long id) {
    this.id = id;
  }

  public long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(long updateTime) {
    this.updateTime = updateTime;
  }

  public Map<String, Object> getAttributes() {
    return attributes;
  }

  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }

  public long getMaintainId() {
    return maintainId;
  }

  public void setMaintainId(long maintainId) {
    this.maintainId = maintainId;
  }

  public int attributeSize() {
    return this.attributes.size();
  }

  public EntityClassRef getEntityClassRef() {
    return entityClassRef;
  }

  public void setEntityClassRef(EntityClassRef entityClassRef) {
    this.entityClassRef = entityClassRef;
  }

  public List<Tuple4<String, String, String, Tuple2<Long, Map<String, Object>>>> getToOneRelatedList() {
    return toOneRelatedList;
  }

  public void setToOneRelatedList(List<Tuple4<String, String, String, Tuple2<Long, Map<String, Object>>>> toOneRelatedList) {
    this.toOneRelatedList = toOneRelatedList;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OqsEngineEntity that = (OqsEngineEntity) o;
    return deleted == that.deleted && version == that.version && id == that.id && updateTime == that.updateTime && Objects.equals(attributes,
        that.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deleted, version, id, updateTime, attributes);
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("OriginalEntity{");
    sb.append("deleted=").append(deleted);
    sb.append(", version=").append(version);
    sb.append(", id=").append(id);
    sb.append(", updateTime=").append(updateTime);
    sb.append(", attributes=").append(attributes);
    sb.append('}');
    return sb.toString();
  }

  @Override
  public Object clone() throws CloneNotSupportedException {
    return OqsEngineEntity.Builder.anOriginalEntity().withId(id).withAttributes(new HashMap<>(attributes)).withDeleted(deleted)
        .withUpdateTime(updateTime).withVersion(version);
  }

  public String getRoutingId() {
    return routingId;
  }

  public void setRoutingId(String routingId) {
    this.routingId = routingId;
  }

  /**
   * 构造器.
   */
  public static final class Builder {

    private boolean deleted;
    private long father;
    private int version;
    private long id;
    private long updateTime;
    private Map<String, Object> attributes = Collections.emptyMap();
    private EntityClassRef entityClassRef;

    public static Builder anOriginalEntity() {
      return new Builder();
    }

    public Builder withDeleted(boolean deleted) {
      this.deleted = deleted;
      return this;
    }

    public Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    public Builder withId(long id) {
      this.id = id;
      return this;
    }

    public Builder withFather(long father) {
      this.father = father;
      return this;
    }

    public Builder withUpdateTime(long updateTime) {
      this.updateTime = updateTime;
      return this;
    }

    public Builder withEntityClassRef(EntityClassRef entityClassRef) {
      this.entityClassRef = entityClassRef;
      return this;
    }

    /**
     * 属性集合.
     */
    public Builder withAttributes(Map<String, Object> attributes) {
      if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
        this.attributes = new HashMap<>();
      }
      this.attributes.putAll(attributes);
      return this;
    }

    /**
     * 属性.
     */
    public Builder withAttribute(String key, Object value) {
      if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
        this.attributes = new HashMap<>();
      }
      this.attributes.put(key, value);
      return this;
    }

    /**
     * 构造实例.
     */
    public OqsEngineEntity build() {
      OqsEngineEntity oqsEngineEntity = new OqsEngineEntity();
      oqsEngineEntity.deleted = this.deleted;
      oqsEngineEntity.updateTime = this.updateTime;
      oqsEngineEntity.id = this.id;
      oqsEngineEntity.version = this.version;
      oqsEngineEntity.entityClassRef = this.entityClassRef;
      oqsEngineEntity.father = this.father;

            /*
            分离附件和字段属性
             */
      oqsEngineEntity.attributes = this.attributes;

      return oqsEngineEntity;
    }
  }
}
