package com.xforceplus.ultraman.metadata.component;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * class to determine whether global metadata has inited
 */
public class GlobalInited {

    private CountDownLatch moduleLatch;

    private Integer timeout;

    private Logger logger = LoggerFactory.getLogger(GlobalInited.class);

    public GlobalInited(Integer size, Integer timeout){
        this.moduleLatch = new CountDownLatch(size);
        this.timeout = timeout;
    }

    public GlobalInited() {

    }

    public void moduleSaved(){
        this.moduleLatch.countDown();
    }

    synchronized public void waiting(){
        try {
            logger.info("Waiting For Module at most {} sec", timeout);
            moduleLatch.await(timeout, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
