package com.xforceplus.ultraman.metadata.domain.vo.dto;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * {
 *      *         pageNo: number,
 *      *         pageSize: number,
 *      *         conditions: {
 *      *             fields: [
 *      *                 {
 *      *                     code: string,
 *      *                     operation: enum{equal, like, in, gteq&lteq, gteq&lt, gt&lteq, gt&lt, gt, gteq, lt, lteq},
 *      *                     value: Array
 *      *                 }
 *      *             ],
 *      *             entities: [
 *      *                 {
 *      *                     code: 'otherEntity',
 *      *                     fields: [
 *      *                         {
 *      *                             code: string,
 *      *                             operation: enum{equal, like, in, gteq&lteq, gteq&lt, gt&lteq, gt&lt, gt, gteq, lt, lteq},
 *      *                             value: Array
 *      *                         }
 *      *                     ],
 *      *                 }
 *      *             ]
 *      *         },
 *      *         sort: [
 *      *             {
 *      *                 field: string,
 *      *                 order: enum{asc, desc}
 *      *             }
 *      *         ],
 *      *         entity: {
 *      *             fields: ['id', 'name', 'field1', 'field2', 'field3'],
 *      *             entities: [
 *      *                 {
 *      *                     code: 'otherEntity1',
 *      *                     fields: ['name'],
 *      *                 },
 *      *                 {
 *      *                     code: 'otherEntity2',
 *      *                     fields: ['name'],
 *      *                 },
 *      *             ],
 *      *         },
 *      *        mapping:[{"code": "", "text":""}],
 *               toManyRelations:[
 *                  {
 *                      code: 'otherEntity3',
 *                      name: '',
 *                      entity:{
 *
 *                      },
 *                      mapping:[{"code": "", "text":""}],
 *                      conditions:[],
 *                       sort: [
 *  *      *             {
 *  *      *                 field: string,
 *  *      *                 order: enum{asc, desc}
 *  *      *             }
 *  *      *         ]
 *                  },{}
 *               ]
 *      *     }
 */
public class ConditionQueryRequest {

    private Integer pageNo;

    private Integer pageSize;

    private Conditions conditions;

    private List<FieldSort> sort;

    //return code
    private EntityItem entity;

    private List<NameMapping> mapping;

    private List<RelationQuery> toManyRelations;

    private String attachment;

    private List<String> group;

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Conditions getConditions() {
        return conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public List<FieldSort> getSort() {
        return sort;
    }

    public void setSort(List<FieldSort> sort) {
        this.sort = sort;
    }

    public EntityItem getEntity() {
        return entity;
    }

    public List<NameMapping> getMapping() {
        return mapping;
    }

    public void setEntity(EntityItem entity) {
        this.entity = entity;
    }

    public void setMapping(List<NameMapping> mapping) {
        this.mapping = mapping;
    }

    public List<RelationQuery> getToManyRelations() {
        return toManyRelations;
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public void setToManyRelations(List<RelationQuery> toManyRelations) {
        this.toManyRelations = toManyRelations;
    }

    private String removeSonCode(String rawString){
        if(rawString.contains("/")){
            return rawString.substring(rawString.lastIndexOf('/') + 1);
        } else {
            return rawString;
        }
    }

    public List<String> getGroup() {
        return group;
    }

    public void setGroup(List<String> group) {
        this.group = group;
    }

    //TODO
    public Set<String> getStringKeys(){
        return Optional.ofNullable(entity).map(x -> {
            Stream<String> stream = x.getFields()
                    .stream()
                    .map(field -> {
                        return removeSonCode(field);
                    });
            Stream<String> keyStream = x.getEntities()
                    .stream().flatMap(sub ->
                            {
                                if(sub.getFields() == null || sub.getFields().isEmpty()){
                                    return Stream.of( sub.getCode() + ".*");
                                } else {
                                    return sub.getFields().stream().map(subField -> "_" + sub.getCode() + "." + removeSonCode(subField));
                                }
                            }
                    );
            return Stream.concat(stream, keyStream).collect(Collectors.toSet());
        }).orElseGet(Collections::emptySet);
    }

    public List<String> getStringKeysOrdered(){
        return Optional.ofNullable(entity).map(x -> {
            Stream<String> stream = x.getFields()
                    .stream()
                    .map(field -> {
                        return removeSonCode(field);
                    });
            Stream<String> keyStream = x.getEntities()
                    .stream().flatMap(sub ->
                            {
                                if(sub.getFields() == null || sub.getFields().isEmpty()){
                                    return Stream.of( sub.getCode() + ".*");
                                } else {
                                    return sub.getFields().stream().map(subField -> "_" + sub.getCode() + "." + removeSonCode(subField));
                                }
                            }
                    );
            return Stream.concat(stream, keyStream).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConditionQueryRequest request = (ConditionQueryRequest) o;
        return Objects.equals(pageNo, request.pageNo) &&
                Objects.equals(pageSize, request.pageSize) &&
                Objects.equals(conditions, request.conditions) &&
                Objects.equals(sort, request.sort) &&
                Objects.equals(entity, request.entity) &&
                Objects.equals(mapping, request.mapping) &&
                Objects.equals(toManyRelations, request.toManyRelations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageNo, pageSize, conditions, sort, entity, mapping, toManyRelations);
    }

    @Override
    public String toString() {
        return "ConditionQueryRequest{" +
                "pageNo=" + pageNo +
                ", pageSize=" + pageSize +
                ", conditions=" + conditions +
                ", sort=" + sort +
                ", entity=" + entity +
                ", mapping=" + mapping +
                ", toManyRelations=" + toManyRelations +
                '}';
    }
}
