package com.xforceplus.ultraman.metadata.helper;

import com.xforceplus.ultraman.metadata.domain.vo.dto.*;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author admin
 */
public class ConditionQueryRequestHelper {

    /**
     * transformer not valid condition to valid condition
     *
     * @param condition
     * @return
     */
    public static void transformer(ConditionQueryRequest condition) {
        if (condition.getConditions() != null) {
            Conditions conditions = condition.getConditions();
            /**
             * transformer field
             */
            Optional.ofNullable(conditions.getFields()).orElseGet(Collections::emptyList)
                    .forEach(ConditionQueryRequestHelper::transformer);

            Optional.ofNullable(conditions.getEntities()).orElseGet(Collections::emptyList).stream()
                    .flatMap(x -> Optional.ofNullable(x.getFields()).orElseGet(Collections::emptyList).stream())
                    .forEach(ConditionQueryRequestHelper::transformer);
        }
    }

    /**
     * only deal the current condition
     * simple
     *
     * @param fieldCondition
     */
    private static void transformer(FieldCondition fieldCondition) {
        ConditionOp operation = fieldCondition.getOperation();

        List<String> values = fieldCondition.getValue();

        /**
         * can be null /
         */
//        if (values.stream().allMatch(Objects::isNull)) {
//            throw new RuntimeException("All Value is Empty and Passed as NULL");
//        }

        switch (operation) {
            case ge_le:
                fallBack(fieldCondition, values, ConditionOp.ge, ConditionOp.le);
                break;
            case ge_lt:
                fallBack(fieldCondition, values, ConditionOp.ge, ConditionOp.lt);
                break;
            case gt_le:
                fallBack(fieldCondition, values, ConditionOp.gt, ConditionOp.le);
                break;
            case gt_lt:
                fallBack(fieldCondition, values, ConditionOp.gt, ConditionOp.lt);
                break;
            default:
        }
    }

    private static void fallBack(FieldCondition fieldCondition, List<String> values, ConditionOp first, ConditionOp second) {
        if (values.size() >= 2) {
            if (values.get(0) == null) {
                //fall back to last
                fieldCondition.setOperation(second);
                fieldCondition.setValue(Arrays.asList(values.get(1)));
            } else if (values.get(1) == null) {
                fieldCondition.setOperation(first);
                fieldCondition.setValue(Arrays.asList(values.get(0)));
            }
        }
    }

    public static ConditionQueryRequest build(List<Long> ids, ConditionQueryRequest condition) {

        //do nothing
        if (ids == null) {
            return condition;
        }

        ConditionQueryRequest newRequest = copyOrNew(condition);

        Conditions conditions = newRequest.getConditions();

        FieldCondition idCondition = new FieldCondition();
        idCondition.setCode("id");
        idCondition.setOperation(ConditionOp.in);
        idCondition.setValue(ids.stream().map(Object::toString).collect(Collectors.toList()));

        if (conditions == null) {
            //new one with ids
            List<FieldCondition> fieldConditions = Collections.singletonList(idCondition);
            Conditions newConditions = new Conditions();
            newConditions.setFields(fieldConditions);
            newRequest.setConditions(newConditions);
        } else {
            List<FieldCondition> fields = conditions.getFields();
            List<FieldCondition> fieldConditions = Optional.ofNullable(fields)
                    .map(LinkedList::new).orElseGet(LinkedList::new);
            fieldConditions.add(idCondition);
            conditions.setFields(fieldConditions);
        }

        return newRequest;
    }

    /**
     * not deep one only replace all reference to new one
     *
     * @param condition
     * @return
     */
    public static ConditionQueryRequest copyOrNew(ConditionQueryRequest condition) {

        ConditionQueryRequest result = new ConditionQueryRequest();
        if (condition == null) {
            return result;
        } else {

            Conditions conditions = condition.getConditions();
            if (conditions != null) {
                Conditions newConditions = new Conditions();
                if (conditions.getFields() != null) {
                    newConditions.setFields(new LinkedList<>(conditions.getFields()));
                }

                if (conditions.getEntities() != null) {
                    newConditions.setEntities(new LinkedList<>(conditions.getEntities()));
                }

                result.setConditions(newConditions);
            }

            List<NameMapping> mapping = condition.getMapping();
            if (mapping != null) {
                result.setMapping(new LinkedList<>(mapping));
            }

            List<FieldSort> sort = condition.getSort();
            if (sort != null) {
                result.setSort(new LinkedList<>(sort));
            }

            EntityItem entity = condition.getEntity();
            if (entity != null) {

                EntityItem newItem = new EntityItem();

                List<SubEntityItem> entities = entity.getEntities();
                List<String> fields = entity.getFields();

                if (entities != null) {
                    newItem.setEntities(new LinkedList<>(entities));
                }

                if (fields != null) {
                    newItem.setFields(new LinkedList<>(fields));
                }
                result.setEntity(newItem);
            }

            result.setPageSize(condition.getPageSize());
            result.setPageNo(condition.getPageNo());

            return result;
        }
    }

    /**
     * remove useless field
     *
     * @param group
     * @param conditionQueryRequest
     * @return
     */
    public static void removeUselessField(
            EntityClassEngine engine
            , EntityClassGroup group
            , String profile
            , ConditionQueryRequest conditionQueryRequest) {

        Collection<IEntityField> allFields = group.getAllFields();

        /**
         * all valid string in current status
         */
        Set<String> validString = allFields.stream()
                .map(IEntityField::name)
                .collect(Collectors.toSet());

        /**
         * filter all entity
         */
        EntityItem entity = conditionQueryRequest.getEntity();
        if (entity != null) {
            List<String> validCodes = Optional.ofNullable(entity.getFields())
                    .orElseGet(Collections::emptyList)
                    .stream().filter(validString::contains)
                    .collect(Collectors.toList());

            entity.setFields(validCodes);

            if (entity.getEntities() != null && !entity.getEntities().isEmpty()) {
                entity.getEntities().stream().forEach(x -> {
                    String relationCode = x.getCode();
                    List<String> requestRelatedCodes = x.getFields();
                    Optional<IEntityClass> relatedEntityClassOp = group.relatedEntityClass(relationCode);
                    if (relatedEntityClassOp.isPresent()) {
                        IEntityClass entityClass = relatedEntityClassOp.get();
                        EntityClassGroup relatedGroup = engine.describe(entityClass, profile);
                        List<String> relatedValidCodes = relatedGroup
                                .getAllFields()
                                .stream()
                                .map(IEntityField::name)
                                .collect(Collectors.toList());

                        List<String> filteredRelatedCodes = requestRelatedCodes.stream()
                                .filter(relatedValidCodes::contains)
                                .collect(Collectors.toList());
                        x.setFields(filteredRelatedCodes);
                    }
                });
            }
        }

        /**
         * filter all condition
         */
        Conditions conditions = conditionQueryRequest.getConditions();

        List<FieldCondition> fields = conditions.getFields();
        List<FieldCondition> filtered = fields.stream()
                .filter(x -> validString.contains(x.getCode()))
                .collect(Collectors.toList());
        conditions.setFields(filtered);

        List<SubFieldCondition> entities = Optional.ofNullable(conditions.getEntities())
                .orElseGet(Collections::emptyList);
        entities.forEach(x -> {
            String code = x.getCode();
            List<FieldCondition> subFields = x.getFields();
            Optional<IEntityClass> relatedEntityClassOp = group.relatedEntityClass(code);
            if (relatedEntityClassOp.isPresent()) {
                IEntityClass entityClass = relatedEntityClassOp.get();
                EntityClassGroup relatedGroup = engine.describe(entityClass, profile);
                List<String> relatedValidCodes = relatedGroup
                        .getAllFields()
                        .stream()
                        .map(IEntityField::name)
                        .collect(Collectors.toList());

                List<FieldCondition> filteredRelatedCodes = subFields.stream()
                        .filter(subFieldCode -> relatedValidCodes.contains(subFieldCode))
                        .collect(Collectors.toList());
                x.setFields(filteredRelatedCodes);
            }
        });
    }
}
