package com.xforceplus.ultraman.metadata.engine;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.ultraman.metadata.domain.vo.dto.AppItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoApiVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.CurrentVersion;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import com.xforceplus.ultraman.sdk.infra.Refreshable;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * entity-class engine
 * an interface to communication with entity-class
 */
public interface EntityClassEngine extends Refreshable {

    List<String> codes();

    MetadataEngine meta();

    String appCode();

    Optional<IEntityClass> load(String boId, String profile);

    Optional<IEntityClass> load(String boId, String profile, String version);

    Optional<IEntityClass> loadByCode(String boCode, String profile);

    Optional<IEntityClass> loadByCode(String boCode, String profile, String version);

    EntityClassGroup describe(IEntityClass entityClass, String profile);

    List<ColumnField> columns(ResourcePath resourcePath, String profile);

    /**
     * root specified
     * @param root
     * @param resourcePath
     * @param profile
     * @return
     */
    List<ColumnField> columns(IEntityClass root, ResourcePath resourcePath, String profile);

    Optional<ColumnField> column(ResourcePath resourcePath, String profile);

    /**
     * root specified
     * @param root
     * @param resourcePath
     * @param profile
     * @return
     */
    Optional<ColumnField> column(IEntityClass root, ResourcePath resourcePath, String profile);

    List<IEntityClass> findAllEntities(String profile);

    /**
     * external
     * @param id
     * @return
     */
    Set<String> findCustomActionsById(long id);

    List<BoApiVo> loadApiByCode(String code, String profile);

    CurrentVersion currentVersion();

    AppItem getCurrentApp();

}
