/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.cdc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import io.vavr.Tuple2;
import io.vavr.Tuple4;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OqsEngineEntity
implements Cloneable {
    private boolean deleted = false;
    private int version = 0;
    private long id = 0L;
    private long updateTime = 0L;
    private long father = 0L;
    private long maintainId;
    private String routingId;
    private Map<String, Object> attributes;
    private EntityClassRef entityClassRef;
    private List<Tuple4<String, String, String, Tuple2<Long, Map<String, Object>>>> toOneRelatedList = new ArrayList<Tuple4<String, String, String, Tuple2<Long, Map<String, Object>>>>();

    public static Map<String, Object> addDynamicAttrWithNullValue(IEntityClass entityClass, String attrStr) throws JsonProcessingException {
        Map<String, Object> result = attrStr.isEmpty() ? new HashMap<String, Object>() : OqsEngineEntity.attributesToMap(attrStr);
        entityClass.selfFields().stream().filter(IEntityField::isDynamic).forEach(f -> {
            if (!result.containsKey(f.name())) {
                result.put(f.name(), null);
            } else if (f.type().equals((Object)FieldType.BOOLEAN)) {
                result.computeIfPresent(f.name(), (k, s) -> (Integer)s != 0);
            }
        });
        return result;
    }

    public static Map<String, Object> attributesToMap(String attrStr) throws JsonProcessingException {
        return (Map)JacksonDefaultMapper.OBJECT_MAPPER.readValue(attrStr, Map.class);
    }

    public long getFather() {
        return this.father;
    }

    public void setFather(long father) {
        this.father = father;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public long getMaintainId() {
        return this.maintainId;
    }

    public void setMaintainId(long maintainId) {
        this.maintainId = maintainId;
    }

    public int attributeSize() {
        return this.attributes.size();
    }

    public EntityClassRef getEntityClassRef() {
        return this.entityClassRef;
    }

    public void setEntityClassRef(EntityClassRef entityClassRef) {
        this.entityClassRef = entityClassRef;
    }

    public List<Tuple4<String, String, String, Tuple2<Long, Map<String, Object>>>> getToOneRelatedList() {
        return this.toOneRelatedList;
    }

    public void setToOneRelatedList(List<Tuple4<String, String, String, Tuple2<Long, Map<String, Object>>>> toOneRelatedList) {
        this.toOneRelatedList = toOneRelatedList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OqsEngineEntity that = (OqsEngineEntity)o;
        return this.deleted == that.deleted && this.version == that.version && this.id == that.id && this.updateTime == that.updateTime && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.deleted, this.version, this.id, this.updateTime, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OriginalEntity{");
        sb.append("deleted=").append(this.deleted);
        sb.append(", version=").append(this.version);
        sb.append(", id=").append(this.id);
        sb.append(", updateTime=").append(this.updateTime);
        sb.append(", attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return Builder.anOriginalEntity().withId(this.id).withAttributes(new HashMap<String, Object>(this.attributes)).withDeleted(this.deleted).withUpdateTime(this.updateTime).withVersion(this.version);
    }

    public String getRoutingId() {
        return this.routingId;
    }

    public void setRoutingId(String routingId) {
        this.routingId = routingId;
    }

    public static final class Builder {
        private boolean deleted;
        private long father;
        private int version;
        private long id;
        private long updateTime;
        private Map<String, Object> attributes = Collections.emptyMap();
        private EntityClassRef entityClassRef;

        public static Builder anOriginalEntity() {
            return new Builder();
        }

        public Builder withDeleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withFather(long father) {
            this.father = father;
            return this;
        }

        public Builder withUpdateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder withEntityClassRef(EntityClassRef entityClassRef) {
            this.entityClassRef = entityClassRef;
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder withAttribute(String key, Object value) {
            if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public OqsEngineEntity build() {
            OqsEngineEntity oqsEngineEntity = new OqsEngineEntity();
            oqsEngineEntity.deleted = this.deleted;
            oqsEngineEntity.updateTime = this.updateTime;
            oqsEngineEntity.id = this.id;
            oqsEngineEntity.version = this.version;
            oqsEngineEntity.entityClassRef = this.entityClassRef;
            oqsEngineEntity.father = this.father;
            oqsEngineEntity.attributes = this.attributes;
            return oqsEngineEntity;
        }
    }
}

