/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.impl;

import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntity;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityFamily;
import com.xforceplus.ultraman.metadata.entity.IEntityValue;
import com.xforceplus.ultraman.metadata.entity.impl.EntityValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class Entity
implements IEntity,
Serializable {
    private boolean deleted;
    private int version;
    private long id;
    private long time;
    private long maintainid;
    private EntityClassRef entityClassRef;
    private IEntityValue entityValue;
    private IEntityClass entityClass;
    private IEntityFamily family;
    private int major;
    private long realEntity;

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public IEntityClass entityClass() {
        return this.entityClass;
    }

    @Override
    public EntityClassRef entityClassRef() {
        return this.entityClassRef;
    }

    @Override
    public IEntityValue entityValue() {
        if (this.entityValue == null) {
            this.entityValue = new EntityValue(this);
        }
        return this.entityValue;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public void resetVersion(int version) {
        this.version = version;
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public void markTime(long time) {
        this.time = time;
    }

    @Override
    public void markTime() {
        this.time = System.currentTimeMillis();
    }

    @Override
    public long maintainId() {
        return this.maintainid;
    }

    @Override
    public IEntity copy() {
        Entity cloneEntity = new Entity();
        cloneEntity.id = this.id;
        cloneEntity.entityClassRef = this.entityClassRef;
        cloneEntity.entityValue = new EntityValue(cloneEntity);
        cloneEntity.entityValue.addValues(this.entityValue.values());
        cloneEntity.version = this.version;
        cloneEntity.time = this.time;
        cloneEntity.maintainid = this.maintainid;
        return cloneEntity;
    }

    public Entity() {
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue) {
        this(id, entityClass, entityValue, null, 0, 1);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, int major) {
        this(id, entityClass, entityValue, null, 0, major);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, int version, int major) {
        this(id, entityClass, entityValue, null, version, major);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, IEntityFamily family, int version, int major) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Invalid class meta information.");
        }
        if (entityValue == null) {
            throw new IllegalArgumentException("Invalid attribute value.");
        }
        this.id = id;
        this.entityClass = entityClass;
        this.entityValue = entityValue;
        if (family != null) {
            this.family = family;
        }
        this.version = version;
        this.major = major;
    }

    @Override
    public void resetId(long id) {
        this.id = id;
    }

    @Override
    public void restMaintainId(long maintainId) {
        this.maintainid = maintainId;
    }

    @Override
    public void delete() {
        this.deleted = true;
        this.neat();
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.id == entity.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Entity{");
        sb.append("deleted=").append(this.deleted);
        sb.append(", entityClassRef=").append(this.entityClassRef);
        sb.append(", entityValue=").append(this.entityValue);
        sb.append(", id=").append(this.id);
        sb.append(", maintainid=").append(this.maintainid);
        sb.append(", time=").append(this.time);
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private long id;
        private long time;
        private EntityClassRef entityClassRef;
        private Collection<IValue> values;
        private int version;
        private long maintainid;

        private Builder() {
        }

        public static Builder anEntity() {
            return new Builder();
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withTime(long time) {
            this.time = time;
            return this;
        }

        public Builder withEntityClassRef(EntityClassRef entityClassRef) {
            this.entityClassRef = entityClassRef;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withMaintainid(long maintainid) {
            this.maintainid = maintainid;
            return this;
        }

        public Builder withValues(Collection<IValue> values) {
            if (this.values == null) {
                this.values = new ArrayList<IValue>();
            }
            this.values.addAll(values);
            return this;
        }

        public Builder withValue(IValue value) {
            if (this.values == null) {
                this.values = new ArrayList<IValue>();
            }
            this.values.add(value);
            return this;
        }

        public Entity build() {
            Entity entity = new Entity();
            entity.maintainid = this.maintainid;
            entity.version = this.version;
            entity.time = this.time;
            entity.entityClassRef = this.entityClassRef;
            entity.id = this.id;
            if (this.values != null) {
                entity.entityValue().addValues(this.values);
            }
            return entity;
        }
    }
}

