package com.xforceplus.ultraman.metadata.domain.func;

public interface FuncTyped {
    
    String getValue();

    class Ref implements FuncTyped {

        String format = "`%s`";
        
        String dynamicFormat = "JSON_UNQUOTE(JSON_EXTRACT(_sys_dynamic, '$.%s')";
        
        boolean isDynamic = false;
        
        String value;

        public Ref(String value) {
            this.value = value;
        }

        public void shiftToDynamic() {
            this.isDynamic = true;
        }
        
        public String getValue() {
            if(isDynamic) {
                return String.format(dynamicFormat, value);   
            } else {
                return String.format(format, value);
            }
        }
    }

    class Literal implements FuncTyped {

        String format = "'%s'";
        String value;

        public Literal(String value) {
            this.value = value;
        }

        public String getValue() {
            return String.format(format, value);
        }
    }
    
    public static FuncTyped  ref(String value) {
        return new Ref(value);
    }
    
    public static FuncTyped literal(String value) {
        return new Literal(value);
    }
    
}
