package com.xforceplus.ultraman.metadata.engine;

import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.table.SystemColumn.INVISIBLE_SYSTEM_WORDS;

/**
 * entity-class group interface
 */
public interface EntityClassGroup {

    Logger log = LoggerFactory.getLogger(EntityClassGroup.class);
    
    List<IEntityField> getFieldsByTypes(FieldType fieldType);
    
    /**
     * TODO
     * zip Value only zip self not consider the children
     *
     * @return
     */
    default Stream<Tuple2<IEntityField, Object>> zipValue(Map<String, Object> body, long id) {
//        this.testBody(body, id).forEach((x) -> {
//            log.warn("[{}] is not available in EntityClass [{}]", x, getEntityClass().code());
//        });

        /**
         * camelCase 
         */
        return getAllFields().stream().filter(x -> !INVISIBLE_SYSTEM_WORDS.contains(x.name())).map(x -> {
            String key = x.name();
//            Object o = body.entrySet().stream()
//                    .filter(y -> y.getKey().equalsIgnoreCase(key))
//                    .map(Map.Entry::getValue).filter(Objects::nonNull).findFirst().orElse(null);
            Object o = body.get(key);
            return Tuple.of(x, o);
        });
    }

    default Set<String> testBody(Map<String, Object> map, long targetId) {
        Set<String> inputKeys = map.keySet();
        Set<String> allKeys = getAllFields().stream().map(IEntityField::name).collect(Collectors.toSet());
        return inputKeys.stream().filter((x) -> {
            return !allKeys.contains(x);
        }).collect(Collectors.toSet());
    }

    Collection<IEntityClass> getFatherEntityClass();

    Collection<IEntityClass> getChildrenEntityClass();

    /**
     * get all relations
     *
     * @return
     */
    Collection<IRelation> getAllRelations();

    /**
     * as all field should have completed fields
     *
     * @return
     */
    Collection<IEntityField> getAllFields();

    Optional<IEntityField> field(String rawCode);

    Optional<IEntityField> field(long fieldId);

    Optional<IRelation> relation(long relationId);

    Optional<IRelation> relation(String relationCode);

    Optional<IEntityClass> relatedEntityClass(String relatedCode);

    IEntityClass getEntityClass();

    String profile();

    /**
     * profile loaded from real metadata
     * @return
     */
    String realProfile();

    EntityClassGroup relatedEntityClassWithRawName(String rawName);

    EntityClassEngine classEngine();

    default EntityClassGroup describe(IEntityClass entityClass) {
        String profile = this.getEntityClass().ref().getProfile();
        return classEngine().describe(entityClass, profile);
    }

    /**
     * record only one record
     *
     * @param body
     * @param entityClassId
     * @return
     */
    Record toRecordNew(Map<Tuple2<String, Long>, Object> body, long entityClassId);

    /**
     * a fieldCode total format
     * <p>
     * A self field  AB X.ID  A:XXX
     * A self sub field
     * A related field _AB.XXX
     * A related sub field _A
     * columne field
     *
     * @param fieldCode
     * @return
     */
    Optional<ColumnField> column(String fieldCode);

    /**
     * support multi fields list
     *
     * @param fieldCode
     * @return
     */
    List<ColumnField> columns(String fieldCode);

    /**
     * return current group fields only from current entityClass to its fathers
     *
     * @return
     */
    List<ColumnField> columns();
    
    String getJoinTable(String tableName);

    Collection<Tuple2<String, String>> getAllToOneReverseRelations();
    
}
