//package com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.conditions.condition;
//
//import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.conditions.ConditionOperator;
//import com.xforceplus.ultraman.metadata.entity.IEntityField;
//import com.xforceplus.ultraman.metadata.values.IValue;
//import java.io.Serializable;
//import java.util.Arrays;
//import java.util.Objects;
//
///**
// * 条件的抽像基础实现.
// *
// * @author dongbin
// * @version 0.1 2022/5/26 16:31
// * @since 1.8
// */
//public abstract class AbstractCondition implements Condition, Serializable {
//
//    /*
//    默认的特殊信息,表示无效.
//     */
//    private static final ConditionSpecialInfo DEFAULT_INFO = new ConditionSpecialInfo(null, 0);
//
//    /*
//     * 字段信息
//     */
//    private IEntityField field;
//
//    /*
//     * 条件值集合
//     */
//    private IValue[] values;
//
//    /*
//     * 操作符.
//     */
//    private ConditionOperator operator;
//
//    /*
//     * 条件特殊信息.
//     */
//    private ConditionSpecialInfo info;
//
//    /*
//     * 是否范围查询
//     */
//    private boolean range;
//
//    /**
//     * 不指定 entityClass 来构造一个条件.实际的 entityClass 将由搜索执行器来假定.
//     *
//     * @param field    字段信息.
//     * @param operator 条件操作符.
//     * @param values   条件比较值列表.
//     */
//    public AbstractCondition(IEntityField field, ConditionOperator operator, IValue... values) {
//        this(field, operator, null, values);
//    }
//
//    /**
//     * 构造一个新的查询条件.
//     *
//     * @param field    字段.
//     * @param operator 比较符号.
//     * @param info     特殊信息.
//     * @param values   条件比较值列表.
//     */
//    public AbstractCondition(IEntityField field,
//                             ConditionOperator operator,
//                             ConditionSpecialInfo info,
//                             IValue... values) {
//        checkValues(values);
//        this.field = field;
//        this.operator = operator;
//        this.values = values;
//        this.info = info == null ? DEFAULT_INFO : info;
//
//        if (!verificationOfAvailability()) {
//            throw new IllegalArgumentException(
//                String.format(
//                    "The %s type does not support the %s operator. Only the %s operator is supported.",
//                    field.type().name(),
//                    operator.name(),
//                    Arrays.toString(field.type().getSuppoertConditionOperator())
//                ));
//        }
//
//        checkRange();
//    }
//
//    /**
//     * 获取当前查询的特殊信息.
//     *
//     * @return 特殊信息.
//     */
//    public ConditionSpecialInfo getSpecialInfo() {
//        return this.info;
//    }
//
//    /**
//     * 条件字段信息.
//     *
//     * @return 条件字段.
//     */
//    public IEntityField getField() {
//        return field;
//    }
//
//    /**
//     * 条件的首个值.所有条件都至少有一个值.
//     *
//     * @return 首个值.
//     */
//    public IValue getFirstValue() {
//        return values[0];
//    }
//
//    /**
//     * 返回所有条件值.
//     *
//     * @return 条件值列表.
//     */
//    public IValue[] getValues() {
//        return Arrays.copyOf(values, values.length);
//    }
//
//    /**
//     * 返回条件比较操作符.
//     *
//     * @return 操作符.
//     */
//    public ConditionOperator getOperator() {
//        return operator;
//    }
//
//    /**
//     * 条件查询是否为范围查询.
//     *
//     * @return true 是, false 不是.
//     */
//    public boolean isRange() {
//        return range;
//    }
//
//    @Override
//    public boolean equals(Object o) {
//        if (this == o) {
//            return true;
//        }
//        if (!(o instanceof Condition)) {
//            return false;
//        }
//        Condition condition = (Condition) o;
//        return isRange() == condition.isRange()
//            && Objects.equals(getSpecialInfo(), condition.getSpecialInfo())
//            && Objects.equals(getField(), condition.getField())
//            && Arrays.equals(getValues(), condition.getValues())
//            && getOperator() == condition.getOperator();
//    }
//
//    @Override
//    public int hashCode() {
//        int result = Objects.hash(getSpecialInfo(), getField(), getOperator(), isRange());
//        result = 31 * result + Arrays.hashCode(getValues());
//        return result;
//    }
//
//    @Override
//    public String toString() {
//        String specialInfo = this.info.isEffective() ? this.info.toString() : "";
//        StringBuilder buff = new StringBuilder();
//        if (specialInfo.length() > 0) {
//            buff.append(specialInfo).append(".");
//        }
//        buff.append(field.name())
//            .append(" ")
//            .append(getOperator().getSymbol())
//            .append(" ");
//        switch (getOperator()) {
//            case MULTIPLE_EQUALS:
//                buff.append("(");
//                int emptyLen = buff.length();
//                for (IValue v : values) {
//                    if (buff.length() > emptyLen) {
//                        buff.append(", ");
//                    }
//                    appendValue(buff, v);
//                }
//                buff.append(")");
//                break;
//            default:
//                appendValue(buff, getFirstValue());
//        }
//        return buff.toString();
//    }
//
//    protected boolean verificationOfAvailability() {
//        if (!Arrays.stream(field.type().getSuppoertConditionOperator()).anyMatch(op -> op == operator)) {
//            return false;
//        } else {
//            return true;
//        }
//    }
//
//    /**
//     * 修改当前查询条件的值.
//     *
//     * @param newValues 新的值.
//     */
//    protected void changeValues(IValue... newValues) {
//        checkValues(newValues);
//
//        this.values = newValues;
//    }
//
//    private void checkValues(IValue... values) {
//        if (values == null || values.length == 0) {
//            throw new IllegalArgumentException("Invalid query condition, must have at least one value.");
//        }
//    }
//
//    private void appendValue(StringBuilder buff, IValue value) {
//        switch (value.getField().type()) {
//            case STRING:
//            case ENUM:
//                buff.append("\"")
//                    .append(value.valueToString())
//                    .append("\"");
//                break;
//            default:
//                buff.append(value.valueToString());
//        }
//    }
//
//    /**
//     * 判断是否含有范围查询符号.
//     * 特殊,如果查询字段类型为标示类型那么也认为是range.
//     */
//    private void checkRange() {
//
//        if (field.config().isIdentifie()) {
//            range = true;
//            return;
//        }
//
//        if (ConditionOperator.IS_NULL == getOperator() || ConditionOperator.IS_NOT_NULL == getOperator()) {
//            range = true;
//            return;
//        }
//
//        switch (getOperator()) {
//            case LESS_THAN:
//            case GREATER_THAN:
//            case LESS_THAN_EQUALS:
//            case GREATER_THAN_EQUALS:
//                range = true;
//                break;
//            default:
//                range = false;
//        }
//    }
//}
