package com.xforceplus.ultraman.metadata.service;

import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;

import java.util.List;
import java.util.Map;

/**
 * dict service for dict usage
 */
public interface DictService {

    /**
     * 根据字典ID查找字典信息，根据字典id+code查找具体的字典项
     * @param enumId
     * @param enumCode
     * @return
     */
    List<DictItem> findDictItems(String enumId, String enumCode, String tenantCode);

    List<DictItem> findDictItems(String enumId, String enumCode);

    List<DictItem> findDictItems(String enumId, String enumCode, Map<String, Object> context);

    /**
     * 根据字典code查找字典信息，根据code+enumCode查找字典项
     * @return
     */
    List<DictItem> findDictItemsByCode(String code, String enumCode);

    List<DictItem> findDictItemsByCode(String code, String enumCode, String tenantCode);

    /**
     * 查找全部信息
     * @return
     */
    List<DictItem> findAllDictItems(String tenantCode);

    List<DictItem> findAllDictItems();

    Integer findEnumIndex(List<DictItem> dictItems, String value);
}
