/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.values.verifier;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.metadata.values.verifier.ValueVerifier;
import com.xforceplus.ultraman.sdk.infra.utils.NumberUtils;
import java.math.BigDecimal;

public class DecimalValueVerifier
implements ValueVerifier {
    @Override
    public boolean isTooLong(IEntityField field, IValue value) {
        BigDecimal decimal = (BigDecimal)value.getValue();
        int len = NumberUtils.size((long)decimal.longValue());
        return (len += decimal.scale()) <= field.config().getLen();
    }

    @Override
    public boolean isHighPrecision(IEntityField field, IValue value) {
        int scale;
        BigDecimal decimal = (BigDecimal)value.getValue();
        int precision = field.config().getPrecision();
        if (precision == 0) {
            precision = 1;
        }
        return (scale = decimal.scale()) <= precision;
    }
}

