/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.domain.func;

public interface FuncTyped {
    public String getValue();

    public static FuncTyped ref(String value) {
        return new Ref(value);
    }

    public static FuncTyped literal(String value) {
        return new Literal(value);
    }

    public static class Literal
    implements FuncTyped {
        String format = "'%s'";
        String value;

        public Literal(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return String.format(this.format, this.value);
        }
    }

    public static class Ref
    implements FuncTyped {
        String format = "`%s`";
        String dynamicFormat = "JSON_UNQUOTE(JSON_EXTRACT(_sys_dynamic, '$.%s')";
        boolean isDynamic = false;
        String value;

        public Ref(String value) {
            this.value = value;
        }

        public void shiftToDynamic() {
            this.isDynamic = true;
        }

        @Override
        public String getValue() {
            if (this.isDynamic) {
                return String.format(this.dynamicFormat, this.value);
            }
            return String.format(this.format, this.value);
        }
    }
}

