/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.AbstractValue;
import com.xforceplus.ultraman.metadata.values.Attachment;
import com.xforceplus.ultraman.metadata.values.IValue;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeValue
extends AbstractValue<LocalDateTime> {
    private final Logger logger = LoggerFactory.getLogger(DateTimeValue.class);
    public static final ZoneId ZONE_ID = ZoneId.of("Asia/Shanghai");
    public static final LocalDateTime MIN_DATE_TIME = LocalDateTime.of(LocalDate.of(0, 1, 1), LocalTime.MIN);
    public static final LocalDateTime MAX_DATE_TIME = LocalDateTime.of(LocalDate.of(9999, 1, 1), LocalTime.MAX);

    public DateTimeValue(IEntityField field, LocalDateTime value) {
        super(field, value);
    }

    public DateTimeValue(IEntityField field, LocalDateTime value, Attachment attachment) {
        super(field, value, attachment);
    }

    public DateTimeValue(IEntityField field, LocalDateTime value, String attachemnt) {
        super(field, value, attachemnt);
    }

    @Override
    LocalDateTime fromString(String value) {
        if (value == null) {
            return null;
        }
        try {
            long timestamp = Long.parseLong(value);
            return DateTimeValue.toLocalDateTime(timestamp);
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public long valueToLong() {
        Instant instant = ((LocalDateTime)this.getValue()).atZone(ZONE_ID).toInstant();
        return instant.toEpochMilli();
    }

    @Override
    protected IValue<LocalDateTime> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new DateTimeValue(newField, (LocalDateTime)this.getValue(), attachment);
    }

    @Override
    protected IValue<LocalDateTime> doCopy(LocalDateTime value) {
        return new DateTimeValue(this.getField(), value, this.getAttachment().copy());
    }

    @Override
    public String valueToString() {
        return Long.toString(this.valueToLong());
    }

    @Override
    public boolean compareByString() {
        return false;
    }

    @Override
    public Long storageValue() {
        return this.valueToLong();
    }

    public static LocalDateTime toLocalDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZONE_ID);
    }
}

