/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.AbstractValue;
import com.xforceplus.ultraman.metadata.values.Attachment;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.metadata.values.able.CalculationsAble;
import java.math.BigDecimal;

public class DecimalValue
extends AbstractValue<BigDecimal>
implements CalculationsAble<BigDecimal> {
    public DecimalValue(IEntityField field, BigDecimal value) {
        this(field, value, "");
    }

    public DecimalValue(IEntityField field, BigDecimal value, Attachment attachment) {
        super(field, value, attachment);
    }

    public DecimalValue(IEntityField field, BigDecimal value, String attachment) {
        super(field, value, attachment);
    }

    @Override
    protected BigDecimal fromString(String value) {
        if (value != null) {
            return new BigDecimal(value);
        }
        return null;
    }

    @Override
    public long valueToLong() {
        return ((BigDecimal)this.getValue()).longValue();
    }

    @Override
    public BigDecimal storageValue() {
        return (BigDecimal)this.getValue();
    }

    @Override
    protected IValue<BigDecimal> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new DecimalValue(newField, (BigDecimal)this.getValue(), attachment);
    }

    @Override
    protected IValue<BigDecimal> doCopy(BigDecimal value) {
        return new DecimalValue(this.getField(), value, this.getAttachment().copy());
    }

    @Override
    public String valueToString() {
        return ((BigDecimal)this.getValue()).toPlainString();
    }

    @Override
    public CalculationsAble<BigDecimal> plus(IValue<BigDecimal> other) {
        BigDecimal left = (BigDecimal)this.getValue();
        BigDecimal right = other.getValue();
        BigDecimal reuslt = left.add(right);
        return new DecimalValue(this.getField(), reuslt, this.getAttachment());
    }

    @Override
    public CalculationsAble<BigDecimal> subtract(IValue<BigDecimal> other) {
        BigDecimal left = (BigDecimal)this.getValue();
        BigDecimal right = other.getValue();
        BigDecimal reuslt = left.subtract(right);
        return new DecimalValue(this.getField(), reuslt, this.getAttachment());
    }

    @Override
    public CalculationsAble<BigDecimal> decrement() {
        return new DecimalValue(this.getField(), ((BigDecimal)this.getValue()).subtract(BigDecimal.ONE), this.getAttachment());
    }

    @Override
    public CalculationsAble<BigDecimal> increment() {
        return new DecimalValue(this.getField(), ((BigDecimal)this.getValue()).add(BigDecimal.ONE), this.getAttachment());
    }
}

