/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.domain.func;

import com.xforceplus.ultraman.metadata.domain.func.FuncValue;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import java.math.BigDecimal;

public abstract class BiNumFuncValue
implements FuncValue {
    private final String key;
    private final Number num;
    private final String expression = "`%s` %s '%s'";

    abstract String getOperator();

    public BiNumFuncValue(String key, Number num) {
        this.key = key;
        this.num = num;
    }

    private String numberToString() {
        if (this.num instanceof BigDecimal) {
            return ((BigDecimal)this.num).toPlainString();
        }
        return this.num.toString();
    }

    @Override
    public String funcExpression() {
        return String.format("`%s` %s '%s'", this.key, this.getOperator(), this.numberToString());
    }

    @Override
    public FieldType type() {
        if (this.num instanceof BigDecimal) {
            return FieldType.DECIMAL;
        }
        return FieldType.LONG;
    }
}

