/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.calculation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Conditions;
import com.xforceplus.ultraman.metadata.entity.AggregationType;
import com.xforceplus.ultraman.metadata.entity.CalculationType;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.calculation.AbstractCalculation;
import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.conditions.ConditionOperator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public class Aggregation
extends AbstractCalculation {
    @JsonProperty(value="classId")
    private long classId;
    @JsonProperty(value="fieldId")
    private long fieldId;
    @JsonProperty(value="relationId")
    private long relationId;
    @JsonProperty(value="aggregationConditions")
    private List<AggregationCondition> aggregationConditions;
    @JsonProperty(value="aggregationType")
    private AggregationType aggregationType = AggregationType.UNKNOWN;
    @JsonProperty(value="condition")
    private Map<Long, Long> aggregationByFields;
    @JsonIgnore
    private Conditions conditions;

    @Override
    public boolean indexAttachment() {
        return !this.aggregationType.equals((Object)AggregationType.COLLECT);
    }

    public Aggregation(CalculationType calculationType) {
        super(calculationType);
    }

    public Aggregation() {
        super(CalculationType.AGGREGATION);
    }

    public long getClassId() {
        return this.classId;
    }

    public void setClassId(long classId) {
        this.classId = classId;
    }

    public long getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(long fieldId) {
        this.fieldId = fieldId;
    }

    public long getRelationId() {
        return this.relationId;
    }

    public void setRelationId(long relationId) {
        this.relationId = relationId;
    }

    public List<AggregationCondition> getAggregationConditions() {
        return this.aggregationConditions;
    }

    public void setAggregationConditions(List<AggregationCondition> aggregationConditions) {
        this.aggregationConditions = aggregationConditions;
    }

    public Map<Long, Long> getAggregationByFields() {
        return this.aggregationByFields;
    }

    public void setAggregationByFields(Map<Long, Long> aggregationByFields) {
        this.aggregationByFields = aggregationByFields;
    }

    public Optional<Conditions> getConditions() {
        return Optional.ofNullable(this.conditions);
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public String toString() {
        return new StringJoiner(", ", Aggregation.class.getSimpleName() + "[", "]").add("classId=" + this.classId).add("fieldId=" + this.fieldId).add("relationId=" + this.relationId).add("conditions=" + this.conditions).add("aggregationType=" + (Object)((Object)this.aggregationType)).add("aggregationByFields=" + this.aggregationByFields).toString();
    }

    @Override
    public AbstractCalculation clone() {
        Aggregation aggregation = new Aggregation();
        aggregation.classId = this.classId;
        aggregation.fieldId = this.fieldId;
        aggregation.level = this.level;
        aggregation.aggregationByFields = this.aggregationByFields;
        aggregation.conditions = this.conditions;
        aggregation.relationId = this.relationId;
        aggregation.aggregationType = this.aggregationType;
        return aggregation;
    }

    public static class AggregationCondition {
        private long entityClassId;
        private String entityClassCode;
        private String profile;
        private long entityFieldId;
        private String entityFieldCode;
        private FieldType fieldType;
        private ConditionOperator conditionOperator;
        private String stringValue;

        public long getEntityClassId() {
            return this.entityClassId;
        }

        public String getEntityClassCode() {
            return this.entityClassCode;
        }

        public String getProfile() {
            return this.profile;
        }

        public long getEntityFieldId() {
            return this.entityFieldId;
        }

        public String getEntityFieldCode() {
            return this.entityFieldCode;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public ConditionOperator getConditionOperator() {
            return this.conditionOperator;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public static final class Builder {
            private long entityClassId;
            private String entityClassCode;
            private String profile;
            private long entityFieldId;
            private String entityFieldCode;
            private FieldType fieldType;
            private ConditionOperator conditionOperator;
            private String stringValue;

            private Builder() {
            }

            public static Builder anAggregationCondition() {
                return new Builder();
            }

            public Builder withEntityClassId(long classId) {
                this.entityClassId = classId;
                return this;
            }

            public Builder withEntityClassCode(String entityClassCode) {
                this.entityClassCode = entityClassCode;
                return this;
            }

            public Builder withProfile(String profile) {
                this.profile = profile;
                return this;
            }

            public Builder withEntityFieldId(long entityFieldId) {
                this.entityFieldId = entityFieldId;
                return this;
            }

            public Builder withEntityFieldCode(String entityFieldCode) {
                this.entityFieldCode = entityFieldCode;
                return this;
            }

            public Builder withEntityFieldType(FieldType fieldType) {
                this.fieldType = fieldType;
                return this;
            }

            public Builder withConditionOperator(ConditionOperator conditionOperator) {
                this.conditionOperator = conditionOperator;
                return this;
            }

            public Builder withStringValue(String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            public AggregationCondition build() {
                AggregationCondition aggregationCondition = new AggregationCondition();
                aggregationCondition.entityClassId = this.entityClassId;
                aggregationCondition.entityClassCode = this.entityClassCode;
                aggregationCondition.entityFieldId = this.entityFieldId;
                aggregationCondition.entityFieldCode = this.entityFieldCode;
                aggregationCondition.conditionOperator = this.conditionOperator;
                aggregationCondition.fieldType = this.fieldType;
                aggregationCondition.profile = this.profile;
                aggregationCondition.stringValue = this.stringValue;
                return aggregationCondition;
            }
        }
    }

    public static final class Builder {
        private long classId;
        private long fieldId;
        private long relationId;
        private Conditions conditions;
        private List<AggregationCondition> aggregationConditions;
        private AggregationType aggregationType;
        private Map<Long, Long> aggregationByFields;

        private Builder() {
        }

        public static Builder anAggregation() {
            return new Builder();
        }

        public Builder withFieldId(long fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public Builder withClassId(long classId) {
            this.classId = classId;
            return this;
        }

        public Builder withRelationId(long relationId) {
            this.relationId = relationId;
            return this;
        }

        public Builder withConditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder withAggregationConditions(List<AggregationCondition> aggregationConditions) {
            this.aggregationConditions = aggregationConditions;
            return this;
        }

        public Builder withAggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        public Builder withAggregationByFields(Map<Long, Long> aggregationByFields) {
            this.aggregationByFields = aggregationByFields;
            return this;
        }

        public Aggregation build() {
            Aggregation aggregation = new Aggregation();
            aggregation.calculationType = CalculationType.AGGREGATION;
            aggregation.classId = this.classId;
            aggregation.fieldId = this.fieldId;
            aggregation.level = 1;
            aggregation.aggregationByFields = this.aggregationByFields;
            aggregation.conditions = this.conditions;
            aggregation.relationId = this.relationId;
            aggregation.aggregationType = this.aggregationType;
            aggregation.aggregationConditions = this.aggregationConditions;
            return aggregation;
        }
    }
}

