/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.calculation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.metadata.entity.CalculationType;
import com.xforceplus.ultraman.metadata.entity.calculation.AbstractCalculation;
import java.util.List;
import java.util.StringJoiner;

public class Formula
extends AbstractCalculation {
    @JsonProperty(value="code")
    protected String code;
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="failedPolicy")
    private FailedPolicy failedPolicy = FailedPolicy.UNKNOWN;
    @JsonProperty(value="failedDefaultValue")
    private Object failedDefaultValue;
    @JsonProperty(value="args")
    private List<String> participateFields;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public FailedPolicy getFailedPolicy() {
        return this.failedPolicy;
    }

    public void setFailedPolicy(FailedPolicy failedPolicy) {
        this.failedPolicy = failedPolicy;
    }

    public Object getFailedDefaultValue() {
        return this.failedDefaultValue;
    }

    public void setFailedDefaultValue(Object failedDefaultValue) {
        this.failedDefaultValue = failedDefaultValue;
    }

    public List<String> getParticipateFields() {
        return this.participateFields;
    }

    public void setParticipateFields(List<String> participateFields) {
        this.participateFields = participateFields;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    private Formula() {
        super(CalculationType.FORMULA);
    }

    @Override
    public AbstractCalculation clone() {
        Formula formula = new Formula();
        formula.participateFields = this.participateFields;
        formula.failedPolicy = this.failedPolicy;
        formula.failedDefaultValue = this.failedDefaultValue;
        formula.level = this.level;
        formula.expression = this.expression;
        formula.code = this.code;
        return formula;
    }

    public String toString() {
        return new StringJoiner(", ", Formula.class.getSimpleName() + "[", "]").add("code='" + this.code + "'").add("expression='" + this.expression + "'").add("failedPolicy=" + (Object)((Object)this.failedPolicy)).add("failedDefaultValue=" + this.failedDefaultValue).add("args=" + this.participateFields).toString();
    }

    public static String codeGenerate(String expression) {
        if (null != expression && !expression.isEmpty()) {
            return expression;
        }
        return "";
    }

    public static enum FailedPolicy {
        UNKNOWN(0),
        THROW_EXCEPTION(1),
        USE_FAILED_DEFAULT_VALUE(2);

        private final int policy;

        private FailedPolicy(int policy) {
            this.policy = policy;
        }

        public int getPolicy() {
            return this.policy;
        }

        public static FailedPolicy instance(int policy) {
            for (FailedPolicy failedPolicy : FailedPolicy.values()) {
                if (failedPolicy.policy != policy) continue;
                return failedPolicy;
            }
            return UNKNOWN;
        }
    }

    public static final class Builder {
        private String expression;
        private FailedPolicy failedPolicy = FailedPolicy.UNKNOWN;
        private Object failedDefaultValue;
        private int level;
        private List<String> participateFields;

        private Builder() {
        }

        public static Builder anFormula() {
            return new Builder();
        }

        public Builder withExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder withFailedPolicy(FailedPolicy failedPolicy) {
            this.failedPolicy = failedPolicy;
            return this;
        }

        public Builder withFailedDefaultValue(Object failedDefaultValue) {
            this.failedDefaultValue = failedDefaultValue;
            return this;
        }

        public Builder withLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder withParticipateFields(List<String> args) {
            this.participateFields = args;
            return this;
        }

        public Formula build() {
            Formula formula = new Formula();
            formula.calculationType = CalculationType.FORMULA;
            formula.expression = this.expression;
            formula.code = Formula.codeGenerate(this.expression);
            formula.level = this.level;
            formula.participateFields = this.participateFields;
            formula.failedPolicy = this.failedPolicy;
            formula.failedDefaultValue = this.failedDefaultValue;
            return formula;
        }
    }
}

