/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.legacy.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.metadata.schema.typed.BoIndex;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityClass
implements IEntityClass {
    @JsonProperty(value="id")
    private long id;
    private int ver;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="appCode")
    private String appCode;
    @JsonProperty(value="version")
    private int version;
    @JsonProperty(value="level")
    private int level;
    @JsonProperty(value="profile")
    private String profile;
    @JsonProperty(value="relations")
    private Collection<IRelation> relations;
    @JsonProperty(value="reverseRelations")
    private Collection<IRelation> reverseRelations;
    @JsonProperty(value="father")
    private IEntityClass father;
    @JsonProperty(value="fields")
    private Collection<IEntityField> fields = Collections.emptyList();
    @JsonProperty(value="indexes")
    private Collection<BoIndex> indexes = Collections.emptyList();
    private Set<String> actions = new HashSet<String>();
    private Set<IEntityClass> entityClasses;
    private Set<IEntityClass> childEntityClasses = new HashSet<IEntityClass>();
    private IEntityClass extendEntityClass;

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public void setType(int type) {
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public int ver() {
        return 0;
    }

    @Override
    public String appCode() {
        return this.appCode;
    }

    @Override
    public String profile() {
        return this.profile;
    }

    @Override
    public String realProfile() {
        return this.profile;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Collection<IRelation> relations() {
        return null;
    }

    @Override
    public Optional<IRelation> relation(Long id) {
        return Optional.empty();
    }

    @Override
    public Optional<IRelation> relation(String relationName) {
        return Optional.empty();
    }

    @Override
    public Collection<Tuple2<String, String>> reverseToOneRelations() {
        return null;
    }

    @Override
    public Collection<String> getEntityTables() {
        return new ArrayList<String>();
    }

    @Override
    public Collection<IEntityClass> entityClasses() {
        return null;
    }

    @Override
    public Set<String> actions() {
        return null;
    }

    @Override
    public Collection<BoIndex> indexes() {
        return this.indexes;
    }

    @Override
    public Collection<BoIndex> uniqueIndexes() {
        return this.indexes.stream().filter(BoIndex::isUnique).collect(Collectors.toList());
    }

    @Override
    public Collection<IEntityClass> childEntityClasses() {
        return null;
    }

    @Override
    public IEntityClass extendEntityClass() {
        return null;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public int level() {
        return this.level;
    }

    private EntityClass() {
    }

    @Deprecated
    public EntityClass(Long id, String code, String name, Collection<IRelation> relations, Collection<IEntityClass> entityClasses, IEntityClass extendEntityClass, Collection<IEntityField> fields) {
        this(id, code, relations, entityClasses, extendEntityClass, fields);
        this.name = name;
    }

    public EntityClass(Long id, int ver, String code, String name, Collection<IRelation> relations, Collection<IEntityClass> entityClasses, IEntityClass extendEntityClass, Collection<IEntityField> fields) {
        this((long)id, ver, code, relations, entityClasses, extendEntityClass, Collections.emptyList(), fields);
        this.name = name;
    }

    @Deprecated
    public EntityClass(long id, String code, Collection<IRelation> relations, Collection<IEntityClass> entityClasses, IEntityClass extendEntityClass, Collection<IEntityField> fields) {
        this(id, 0, code, relations, entityClasses, extendEntityClass, Collections.emptyList(), fields);
    }

    public EntityClass(long id, int ver, String code, Collection<IRelation> relations, Collection<IEntityClass> entityClasses, IEntityClass extendEntityClass, Collection<IEntityClass> simpleSubEntityClasses, Collection<IEntityField> fields) {
        this.id = id;
        this.ver = ver;
        if (this.ver < 0) {
            throw new IllegalArgumentException("The version of Entity Class is invalid and cannot be less than 0.");
        }
        this.code = code;
        this.relations = relations == null ? Collections.emptyList() : new ArrayList<IRelation>(relations);
        this.entityClasses = entityClasses == null ? Collections.emptySet() : new HashSet<IEntityClass>(entityClasses);
        this.fields = fields == null ? Collections.emptyList() : new ArrayList<IEntityField>(fields);
        this.extendEntityClass = extendEntityClass;
        this.childEntityClasses.addAll(simpleSubEntityClasses);
    }

    @Override
    public EntityClassRef ref() {
        return EntityClassRef.Builder.anEntityClassRef().withEntityClassId(this.id).withEntityClassAppCode(this.appCode).withEntityClassCode(this.code).withEntityClassProfile(this.profile).build();
    }

    @Override
    public IEntityClass root() {
        return null;
    }

    @Override
    public String masterQueryTable() {
        return "oqs_".concat(this.appCode).concat("_").concat(this.code());
    }

    @Override
    public String masterWriteTable(boolean withProfile) {
        return "oqs_".concat(this.appCode).concat("_").concat(this.code());
    }

    @Override
    public void resetChildEntityClass(Collection<IEntityClass> childEntityClasses) {
    }

    @Override
    public String indexQueryTable() {
        return null;
    }

    @Override
    public Optional<IEntityClass> father() {
        return Optional.ofNullable(this.father);
    }

    @Override
    public Collection<IEntityClass> family() {
        ArrayList<IEntityClass> familyList = new ArrayList<IEntityClass>(this.level);
        Optional<IEntityClass> current = Optional.of(this);
        while (current.isPresent()) {
            familyList.add(0, current.get());
            current = ((IEntityClass)current.get()).father();
        }
        return familyList;
    }

    @Override
    public Collection<IEntityField> selfWithUnique() {
        ArrayList<IEntityField> all = new ArrayList<IEntityField>(this.selfFields());
        for (IEntityField entityField : this.uniqueFieldCollection()) {
            if (all.contains(entityField)) continue;
            all.add(entityField);
        }
        return all;
    }

    @Override
    public Collection<IEntityField> uniqueFieldCollection() {
        HashMap ef = new HashMap();
        for (BoIndex index : this.uniqueIndexes()) {
            String[] fields;
            String fieldIds = index.getFieldIds();
            for (String name : fields = fieldIds.split(",")) {
                this.field(name).ifPresent(entityField -> ef.put(name, entityField));
            }
        }
        return new ArrayList<IEntityField>(ef.values());
    }

    @Override
    public Collection<IEntityField> selfWithIndex() {
        ArrayList<IEntityField> all = new ArrayList<IEntityField>(this.selfFields());
        for (IEntityField entityField : this.indexFieldCollection()) {
            if (all.contains(entityField)) continue;
            all.add(entityField);
        }
        return all;
    }

    @Override
    public Collection<IEntityField> indexFieldCollection() {
        HashMap ef = new HashMap();
        for (BoIndex index : this.indexes()) {
            for (String name : index.getFieldIds().split(",")) {
                this.field(name).ifPresent(entityField -> ef.put(name, entityField));
            }
        }
        return new ArrayList<IEntityField>(ef.values());
    }

    @Override
    public Collection<IEntityField> selfFields() {
        return this.fields;
    }

    @Override
    public Collection<IEntityField> fields() {
        ArrayList<IEntityField> entityFields = new ArrayList<IEntityField>(this.fields);
        if (null != this.relations) {
            this.relations.forEach(r -> {
                if (null != r && r.isSelfRelation(this.id) && r.getEntityField() != null) {
                    entityFields.add(r.getEntityField());
                }
            });
        }
        if (null != this.father) {
            entityFields.addAll(this.father.fields());
        }
        return entityFields;
    }

    @Override
    public Collection<IEntityField> withoutRelationFields() {
        ArrayList<IEntityField> entityFields = new ArrayList<IEntityField>(this.fields);
        if (null != this.father) {
            entityFields.addAll(this.father.withoutRelationFields());
        }
        return entityFields;
    }

    @Override
    public Collection<IEntityField> selfWithoutRelationFields() {
        return new ArrayList<IEntityField>(this.fields);
    }

    @Override
    public Optional<IEntityField> field(String name) {
        Optional<IEntityField> entityFieldOp = this.fields.stream().filter(f -> name.equals(f.name())).findFirst();
        if (entityFieldOp.isPresent()) {
            return entityFieldOp;
        }
        if (this.relations != null) {
            for (IRelation relation : this.relations) {
                if (!relation.isSelfRelation(this.id) || relation.getEntityField() == null || !relation.getEntityField().name().equals(name)) continue;
                return Optional.of(relation.getEntityField());
            }
        }
        if (null != this.father) {
            return this.father.field(name);
        }
        return entityFieldOp;
    }

    @Override
    public Optional<IEntityField> field(long id) {
        Optional<IEntityField> entityFieldOp = this.fields.stream().filter(f -> id == f.id()).findFirst();
        if (entityFieldOp.isPresent()) {
            return entityFieldOp;
        }
        if (this.relations != null) {
            for (IRelation relation : this.relations) {
                if (!relation.isSelfRelation(this.id) || relation.getEntityField() == null || relation.getEntityField().id() != id) continue;
                return Optional.of(relation.getEntityField());
            }
        }
        if (null != this.father) {
            return this.father.field(id);
        }
        return entityFieldOp;
    }

    @Override
    public boolean isAny() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityClass)) {
            return false;
        }
        EntityClass that = (EntityClass)o;
        return this.id == that.id && this.version == that.version && this.level == that.level && Objects.equals(this.profile, that.profile) && Objects.equals(this.name, that.name) && Objects.equals(this.code, that.code) && Objects.equals(this.appCode, that.appCode) && Objects.equals(this.father, that.father) && Objects.equals(this.relations, that.relations) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.code, this.version, this.level, this.relations, this.father, this.fields);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EntityClass{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", code='").append(this.code).append('\'');
        sb.append(", profile='").append(this.profile).append('\'');
        sb.append(", appCode='").append(this.appCode).append('\'');
        sb.append(", version=").append(this.version);
        sb.append(", level=").append(this.level);
        sb.append(", relations=").append(this.relations);
        sb.append(", father=").append(this.father);
        sb.append(", fields=").append(this.fields);
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private long id;
        private String name;
        private String code;
        private String appCode;
        private int version;
        private int level;
        private String profile;
        private Collection<IRelation> relations = Collections.emptyList();
        private IEntityClass father;
        private Collection<IEntityField> fields = Collections.emptyList();
        private List<BoIndex> indexes;

        private Builder() {
        }

        public static Builder anEntityClass() {
            return new Builder();
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Builder withAppCode(String appCode) {
            this.appCode = appCode;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withIndex(List<BoIndex> indexes) {
            this.indexes = indexes;
            return this;
        }

        public Builder withLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder withRelations(Collection<IRelation> relations) {
            this.relations = relations;
            return this;
        }

        public Builder withFather(IEntityClass father) {
            this.father = father;
            return this;
        }

        public Builder withFields(Collection<IEntityField> fields) {
            this.fields = fields;
            return this;
        }

        public Builder withField(IEntityField field) {
            if (Collections.emptyList().getClass().equals(this.fields.getClass())) {
                this.fields = new ArrayList<IEntityField>(this.fields);
            }
            this.fields.add(field);
            return this;
        }

        public EntityClass build() {
            EntityClass entityClass = new EntityClass();
            entityClass.id = this.id;
            entityClass.code = this.code;
            entityClass.appCode = this.appCode;
            entityClass.name = this.name;
            entityClass.level = this.level;
            entityClass.version = this.version;
            entityClass.father = this.father;
            entityClass.fields = this.fields;
            entityClass.relations = this.relations;
            if (this.profile == null) {
                entityClass.profile = "";
            } else {
                entityClass.profile = this.profile;
            }
            entityClass.indexes = this.indexes == null ? new HashSet() : this.indexes;
            return entityClass;
        }
    }
}

