/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity;

import com.xforceplus.ultraman.metadata.entity.IIndex;
import com.xforceplus.ultraman.metadata.entity.IndexRelation;
import com.xforceplus.ultraman.metadata.entity.IndexType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class EntityIndex
implements IIndex {
    private Set<String> indexes;
    private String indexName;
    private IndexType indexType;
    private IndexRelation indexRelation;

    @Override
    public boolean match(Collection<String> indexes) {
        HashSet<String> copy = new HashSet<String>(indexes);
        if (this.indexes.size() != copy.size()) {
            return false;
        }
        for (String element : copy) {
            if (this.indexes.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnique() {
        return this.indexType.equals((Object)IndexType.UNIQUE);
    }

    @Override
    public Set<String> indexes() {
        return this.indexes;
    }

    public static final class Builder {
        private Set<String> indexes;
        private String indexName;
        private IndexType indexType;
        private IndexRelation indexRelation;

        private Builder() {
        }

        public static Builder anEntityIndex() {
            return new Builder();
        }

        public Builder withIndexes(Set<String> indexes) {
            this.indexes = indexes;
            return this;
        }

        public Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder withIndexRelation(IndexRelation indexRelation) {
            this.indexRelation = indexRelation;
            return this;
        }

        public Builder withIndexType(IndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        public EntityIndex build() {
            EntityIndex entityIndex = new EntityIndex();
            entityIndex.indexes = this.indexes == null ? new HashSet() : this.indexes;
            entityIndex.indexName = this.indexName;
            entityIndex.indexRelation = this.indexRelation;
            entityIndex.indexType = this.indexType;
            return entityIndex;
        }
    }
}

