//package com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.entity;
//
//import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.conditions.ConditionOperator;
//import com.xforceplus.ultraman.oqsengine.plus.meta.pojo.dto.entity.impl.EntityField;
//import com.xforceplus.ultraman.metadata.values.BooleanValue;
//import com.xforceplus.ultraman.metadata.values.DateTimeValue;
//import com.xforceplus.ultraman.metadata.values.DecimalValue;
//import com.xforceplus.ultraman.metadata.values.EnumValue;
//import com.xforceplus.ultraman.metadata.values.IValue;
//import com.xforceplus.ultraman.metadata.values.LongValue;
//import com.xforceplus.ultraman.metadata.values.StringValue;
//import com.xforceplus.ultraman.metadata.values.StringsValue;
//import java.math.BigDecimal;
//import java.time.Instant;
//import java.time.LocalDateTime;
//import java.util.Date;
//import java.util.Objects;
//import java.util.Optional;
//import java.util.function.BiFunction;
//import java.util.function.Predicate;
//import java.util.function.Supplier;
//import java.util.stream.Stream;
//
///**
// * 字段类型枚举信息.
// *
// * @author wangzheng
// * @version 1.0 2020/3/26 15:10
// */
//public enum FieldType {
//
//    /**
//     * unknown field.
//     */
//    UNKNOWN("Unknown", s -> false, StringValue::new),
//
//    /**
//     * boolean.
//     */
//    BOOLEAN("Boolean",
//        Boolean.class,
//        s ->
//            s.equalsIgnoreCase("TRUE") || s.equalsIgnoreCase("FALSE"),
//        () -> "false",
//        new String[] {"boolean"},
//        (f, v) ->
//            new BooleanValue(f, Boolean.parseBoolean(v)),
//        (v1, v2) -> {
//            Boolean value1 = ((BooleanValue) v1).getValue();
//            Boolean value2 = ((BooleanValue) v2).getValue();
//            return Boolean.compare(value1, value2);
//        },
//        new ConditionOperator[] {
//            ConditionOperator.EQUALS,
//            ConditionOperator.NOT_EQUALS,
//            ConditionOperator.IS_NULL,
//            ConditionOperator.IS_NOT_NULL,
//            ConditionOperator.MULTIPLE_EQUALS,
//        }
//    ),
//    /**
//     * enum.
//     */
//    ENUM("Enum",
//        String.class,
//        s -> true,
//        () -> "",
//        new String[] {"enum"},
//        EnumValue::new,
//        (v1, v2) -> v1.valueToString().compareTo(v2.valueToString()),
//        new ConditionOperator[] {
//            ConditionOperator.EQUALS,
//            ConditionOperator.NOT_EQUALS,
//            ConditionOperator.IS_NULL,
//            ConditionOperator.IS_NOT_NULL,
//            ConditionOperator.MULTIPLE_EQUALS,
//        }
//    ),
//
//    /**
//     * datetime.
//     */
//    DATETIME("DateTime",
//        Long.class,
//        s -> {
//            try {
//                Instant.ofEpochMilli(Long.parseLong(s));
//                return true;
//            } catch (Exception e) {
//                return false;
//            }
//        },
//        () -> Long.toString(new Date(0).getTime()),
//        new String[] {"timestamp"},
//        (f, v) -> {
//            Instant instant = Instant.ofEpochMilli(Long.parseLong(v));
//            return new DateTimeValue(f, LocalDateTime.ofInstant(instant, DateTimeValue.ZONE_ID));
//        },
//        (v1, v2) -> {
//            LocalDateTime value1 = ((DateTimeValue) v1).getValue();
//            LocalDateTime value2 = ((DateTimeValue) v2).getValue();
//            return value1.compareTo(value2);
//        },
//        new ConditionOperator[] {
//            ConditionOperator.EQUALS,
//            ConditionOperator.NOT_EQUALS,
//            ConditionOperator.IS_NULL,
//            ConditionOperator.IS_NOT_NULL,
//            ConditionOperator.MULTIPLE_EQUALS,
//            ConditionOperator.GREATER_THAN,
//            ConditionOperator.GREATER_THAN_EQUALS,
//            ConditionOperator.LESS_THAN,
//            ConditionOperator.LESS_THAN_EQUALS,
//        }
//    ),
//    /**
//     * Long.
//     */
//    LONG("Long",
//        Long.class,
//        s -> {
//            try {
//                Long.parseLong(s);
//                return true;
//            } catch (Exception e) {
//                return false;
//            }
//        },
//        () -> "0",
//        new String[] {"bigint", "long", "serialNo"},
//        (f, v) -> new LongValue(f, Long.parseLong(v)),
//        (v1, v2) -> {
//            Long value1 = ((LongValue) v1).getValue();
//            Long value2 = ((LongValue) v2).getValue();
//            return Long.compare(value1, value2);
//        },
//        new ConditionOperator[] {
//            ConditionOperator.EQUALS,
//            ConditionOperator.NOT_EQUALS,
//            ConditionOperator.IS_NULL,
//            ConditionOperator.IS_NOT_NULL,
//            ConditionOperator.MULTIPLE_EQUALS,
//            ConditionOperator.GREATER_THAN,
//            ConditionOperator.GREATER_THAN_EQUALS,
//            ConditionOperator.LESS_THAN,
//            ConditionOperator.LESS_THAN_EQUALS,
//        }
//    ),
//    /**
//     * String.
//     */
//    STRING("String",
//        String.class,
//        s -> true,
//        () -> "",
//        new String[] {" string"},
//        StringValue::new,
//        (v1, v2) -> v1.valueToString().compareTo(v2.valueToString()),
//        new ConditionOperator[] {
//            ConditionOperator.EQUALS,
//            ConditionOperator.NOT_EQUALS,
//            ConditionOperator.IS_NULL,
//            ConditionOperator.IS_NOT_NULL,
//            ConditionOperator.MULTIPLE_EQUALS,
//            ConditionOperator.GREATER_THAN,
//            ConditionOperator.GREATER_THAN_EQUALS,
//            ConditionOperator.LESS_THAN,
//            ConditionOperator.LESS_THAN_EQUALS,
//            ConditionOperator.LIKE,
//        }
//    ),
//    /**
//     * strings.
//     */
//    STRINGS("Strings",
//        String.class,
//        s -> {
//            try {
//                s.trim().split(",");
//                return true;
//            } catch (Exception e) {
//                return false;
//            }
//        },
//        () -> "",
//        new String[] {"strings"}, (x, str) -> new StringsValue(x, str.trim().split(",")),
//        (v1, v2) -> 0,
//        new ConditionOperator[] {
//            ConditionOperator.IS_NULL,
//            ConditionOperator.IS_NOT_NULL,
//            ConditionOperator.MULTIPLE_EQUALS,
//            ConditionOperator.EQUALS,
//            ConditionOperator.NOT_EQUALS
//        }
//    ),
//    /**
//     * decimal.
//     */
//    DECIMAL("Decimal",
//        BigDecimal.class, s -> {
//        try {
//            new BigDecimal(s);
//            return true;
//        } catch (Exception e) {
//            return false;
//        }
//    }, () -> "0.0", new String[] {"double", "decimal"}, (f, v) -> new DecimalValue(f, new BigDecimal(v)),
//        (v1, v2) -> {
//            BigDecimal value1 = ((DecimalValue) v1).getValue();
//            BigDecimal value2 = ((DecimalValue) v2).getValue();
//            return value1.compareTo(value2);
//        },
//        new ConditionOperator[] {
//            ConditionOperator.EQUALS,
//            ConditionOperator.NOT_EQUALS,
//            ConditionOperator.IS_NULL,
//            ConditionOperator.IS_NOT_NULL,
//            ConditionOperator.MULTIPLE_EQUALS,
//            ConditionOperator.GREATER_THAN,
//            ConditionOperator.GREATER_THAN_EQUALS,
//            ConditionOperator.LESS_THAN,
//            ConditionOperator.LESS_THAN_EQUALS,
//        }
//    );
//
//    private String type;
//
//    private Predicate<String> tester;
//
//    private Supplier<String> defaultSortValue;
//
//    private String[] accepts;
//
//    private Class javaType;
//
//    private BiFunction<IEntityField, String, IValue> valueConverter;
//
//    private BiFunction<IValue, IValue, Integer> comparator;
//
//    private ConditionOperator[] suppoertConditionOperator;
//
//    /**
//     * 构造实例.
//     *
//     * @param type           字段类型的字面量表示.
//     * @param javaType       字段的值实际JAVA类型.
//     * @param tester         测试判断是否可以通过字符串构造.
//     * @param accepts        接受的元数据定义名称.
//     * @param valueConverter 转换为IValue实例.
//     * @param comparator     比较器.
//     */
//    FieldType(String type,
//              Class javaType,
//              Predicate<String> tester,
//              Supplier<String> defaultSortValue,
//              String[] accepts,
//              BiFunction<IEntityField, String, IValue> valueConverter,
//              BiFunction<IValue, IValue, Integer> comparator,
//              ConditionOperator[] suppoertConditionOperator) {
//        this.type = type;
//        this.tester = tester;
//        this.defaultSortValue = defaultSortValue;
//        this.accepts = accepts;
//        this.valueConverter = valueConverter;
//        this.javaType = javaType;
//        this.comparator = comparator;
//        this.suppoertConditionOperator = suppoertConditionOperator;
//    }
//
//    FieldType(String type, Predicate<String> tester, BiFunction<IEntityField, String, IValue> valueConverter) {
//        this(type, String.class, tester, () -> "0", new String[] {}, valueConverter,
//            (v1, v2) -> v1.valueToString().compareTo(v2.valueToString()), new ConditionOperator[0]);
//    }
//
//    public String getType() {
//        return type;
//    }
//
//    public ConditionOperator[] getSuppoertConditionOperator() {
//        return suppoertConditionOperator;
//    }
//
//    public boolean canParseFrom(String input) {
//        return tester.test(input);
//    }
//
//    public String getDefaultSortValue() {
//        return defaultSortValue.get();
//    }
//
//    /**
//     * 两个以字符串表示的值进行比较.
//     */
//    public int compareFromStringValue(String o1, String o2) {
//        if (comparator == null) {
//            return 0;
//        }
//
//        IEntityField field = new EntityField(-1, "dummy", this);
//
//        IValue ivalueA = this.valueConverter.apply(field, o1);
//        IValue ivalueB = this.valueConverter.apply(field, o2);
//
//        return this.comparator.apply(ivalueA, ivalueB);
//    }
//
//    /**
//     * 获得字段的IValue实例.
//     *
//     * @param entityField 字段.
//     * @param value       值字符串表示.
//     * @return IValue实例.
//     */
//    public Optional<IValue> toTypedValue(IEntityField entityField, String value) {
//        Objects.requireNonNull(value, "value值不能为空");
//        Objects.requireNonNull(entityField, "field值不能为空");
//
//        if (this.tester.test(value)) {
//            return Optional.ofNullable(valueConverter.apply(entityField, value));
//        } else {
//            return Optional.empty();
//        }
//    }
//
//    public boolean accept(String rawType) {
//        return Stream.of(accepts).anyMatch(x -> x.equalsIgnoreCase(rawType));
//    }
//
//    public Class getJavaType() {
//        return javaType;
//    }
//
//    /**
//     * 解析字段格式.
//     *
//     * @param rawType 字符串表示.
//     * @return 实例.
//     */
//    public static FieldType fromRawType(String rawType) {
//
//        try {
//            return FieldType.valueOf(rawType.toUpperCase());
//        } catch (Exception ex) {
//            //to
//        }
//
//        return Stream.of(FieldType.values())
//            .filter(x -> x.accept(rawType))
//            .findFirst().orElse(FieldType.STRING);
//    }
//}
