/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.domain.vo.dto;

import com.xforceplus.ultraman.metadata.domain.vo.dto.Conditions;
import com.xforceplus.ultraman.metadata.domain.vo.dto.EntityItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldSort;
import com.xforceplus.ultraman.metadata.domain.vo.dto.NameMapping;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RelationQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConditionQueryRequest {
    private Integer pageNo;
    private Integer pageSize;
    private Conditions conditions;
    private List<FieldSort> sort;
    private EntityItem entity;
    private List<NameMapping> mapping;
    private List<RelationQuery> toManyRelations;
    private String attachment;
    private List<String> group;

    public Integer getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public List<FieldSort> getSort() {
        return this.sort;
    }

    public void setSort(List<FieldSort> sort) {
        this.sort = sort;
    }

    public EntityItem getEntity() {
        return this.entity;
    }

    public List<NameMapping> getMapping() {
        return this.mapping;
    }

    public void setEntity(EntityItem entity) {
        this.entity = entity;
    }

    public void setMapping(List<NameMapping> mapping) {
        this.mapping = mapping;
    }

    public List<RelationQuery> getToManyRelations() {
        return this.toManyRelations;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public void setToManyRelations(List<RelationQuery> toManyRelations) {
        this.toManyRelations = toManyRelations;
    }

    private String removeSonCode(String rawString) {
        if (rawString.contains("/")) {
            return rawString.substring(rawString.lastIndexOf(47) + 1);
        }
        return rawString;
    }

    public List<String> getGroup() {
        return this.group;
    }

    public void setGroup(List<String> group) {
        this.group = group;
    }

    public Set<String> getStringKeys() {
        return Optional.ofNullable(this.entity).map(x -> {
            Stream<String> stream = x.getFields().stream().map(field -> this.removeSonCode((String)field));
            Stream keyStream = x.getEntities().stream().flatMap(sub -> {
                if (sub.getFields() == null || sub.getFields().isEmpty()) {
                    return Stream.of(sub.getCode() + ".*");
                }
                return sub.getFields().stream().map(subField -> "_" + sub.getCode() + "." + this.removeSonCode((String)subField));
            });
            return Stream.concat(stream, keyStream).collect(Collectors.toSet());
        }).orElseGet(Collections::emptySet);
    }

    public List<String> getStringKeysOrdered() {
        return Optional.ofNullable(this.entity).map(x -> {
            Stream<String> stream = x.getFields().stream().map(field -> this.removeSonCode((String)field));
            Stream keyStream = x.getEntities().stream().flatMap(sub -> {
                if (sub.getFields() == null || sub.getFields().isEmpty()) {
                    return Stream.of(sub.getCode() + ".*");
                }
                return sub.getFields().stream().map(subField -> "_" + sub.getCode() + "." + this.removeSonCode((String)subField));
            });
            return Stream.concat(stream, keyStream).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionQueryRequest request = (ConditionQueryRequest)o;
        return Objects.equals(this.pageNo, request.pageNo) && Objects.equals(this.pageSize, request.pageSize) && Objects.equals(this.conditions, request.conditions) && Objects.equals(this.sort, request.sort) && Objects.equals(this.entity, request.entity) && Objects.equals(this.mapping, request.mapping) && Objects.equals(this.toManyRelations, request.toManyRelations);
    }

    public int hashCode() {
        return Objects.hash(this.pageNo, this.pageSize, this.conditions, this.sort, this.entity, this.mapping, this.toManyRelations);
    }

    public String toString() {
        return "ConditionQueryRequest{pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", conditions=" + this.conditions + ", sort=" + this.sort + ", entity=" + this.entity + ", mapping=" + this.mapping + ", toManyRelations=" + this.toManyRelations + '}';
    }
}

