/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.AbstractValue;
import com.xforceplus.ultraman.metadata.values.Attachment;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.metadata.values.able.CalculationsAble;

public class LongValue
extends AbstractValue<Long>
implements CalculationsAble<Long> {
    public LongValue(IEntityField field, int value) {
        super(field, Long.valueOf(value));
    }

    public LongValue(IEntityField field, long value) {
        super(field, value);
    }

    public LongValue(IEntityField field, int value, Attachment attachment) {
        super(field, Long.valueOf(value), attachment);
    }

    public LongValue(IEntityField field, int value, String attachment) {
        super(field, Long.valueOf(value), attachment);
    }

    public LongValue(IEntityField field, long value, Attachment attachment) {
        super(field, Long.valueOf(value), attachment);
    }

    public LongValue(IEntityField field, long value, String attachment) {
        super(field, Long.valueOf(value), attachment);
    }

    @Override
    Long fromString(String value) {
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    @Override
    public long valueToLong() {
        return (Long)this.getValue();
    }

    @Override
    protected IValue<Long> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new LongValue(newField, (long)((Long)this.getValue()), attachment);
    }

    @Override
    protected IValue<Long> doCopy(Long value) {
        return new LongValue(this.getField(), (long)value, this.getAttachment().copy());
    }

    @Override
    public boolean compareByString() {
        return false;
    }

    @Override
    public Long storageValue() {
        return (Long)this.getValue();
    }

    @Override
    public CalculationsAble<Long> plus(IValue<Long> other) {
        long left = (Long)this.getValue();
        long right = other.getValue();
        return new LongValue(this.getField(), left + right, this.getAttachment().copy());
    }

    @Override
    public CalculationsAble<Long> subtract(IValue<Long> other) {
        long left = (Long)this.getValue();
        long right = other.getValue();
        return new LongValue(this.getField(), left - right, this.getAttachment().copy());
    }

    @Override
    public CalculationsAble<Long> decrement() {
        return new LongValue(this.getField(), (Long)this.getValue() - 1L, this.getAttachment().copy());
    }

    @Override
    public CalculationsAble<Long> increment() {
        return new LongValue(this.getField(), (Long)this.getValue() + 1L, this.getAttachment().copy());
    }
}

