/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.cdc;

import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class OqsEngineEntity
implements Cloneable {
    private boolean deleted = false;
    private int version = 0;
    private long id = 0L;
    private long updateTime = 0L;
    private long father = 0L;
    private Map<String, Object> attributes;
    private EntityClassRef entityClassRef;

    public long getFather() {
        return this.father;
    }

    public void setFather(long father) {
        this.father = father;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int getVersion() {
        return this.version;
    }

    public long getId() {
        return this.id;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public int attributeSize() {
        return this.attributes.size();
    }

    public EntityClassRef getEntityClassRef() {
        return this.entityClassRef;
    }

    public void setEntityClassRef(EntityClassRef entityClassRef) {
        this.entityClassRef = entityClassRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OqsEngineEntity that = (OqsEngineEntity)o;
        return this.deleted == that.deleted && this.version == that.version && this.id == that.id && this.updateTime == that.updateTime && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.deleted, this.version, this.id, this.updateTime, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OriginalEntity{");
        sb.append("deleted=").append(this.deleted);
        sb.append(", version=").append(this.version);
        sb.append(", id=").append(this.id);
        sb.append(", updateTime=").append(this.updateTime);
        sb.append(", attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return Builder.anOriginalEntity().withId(this.id).withAttributes(new HashMap<String, Object>(this.attributes)).withDeleted(this.deleted).withUpdateTime(this.updateTime).withVersion(this.version);
    }

    public static final class Builder {
        private boolean deleted;
        private long father;
        private int version;
        private long id;
        private long updateTime;
        private Map<String, Object> attributes = Collections.emptyMap();
        private EntityClassRef entityClassRef;

        public static Builder anOriginalEntity() {
            return new Builder();
        }

        public Builder withDeleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withFather(long father) {
            this.father = father;
            return this;
        }

        public Builder withUpdateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder withEntityClassRef(EntityClassRef entityClassRef) {
            this.entityClassRef = entityClassRef;
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder withAttribute(String key, Object value) {
            if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public OqsEngineEntity build() {
            OqsEngineEntity oqsEngineEntity = new OqsEngineEntity();
            oqsEngineEntity.deleted = this.deleted;
            oqsEngineEntity.updateTime = this.updateTime;
            oqsEngineEntity.id = this.id;
            oqsEngineEntity.version = this.version;
            oqsEngineEntity.entityClassRef = this.entityClassRef;
            oqsEngineEntity.father = this.father;
            oqsEngineEntity.attributes = this.attributes;
            return oqsEngineEntity;
        }
    }
}

