/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.legacy.impl;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IEntityValue;
import com.xforceplus.ultraman.metadata.entity.impl.EntityValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MixedEntityValue
implements IEntityValue,
Cloneable,
Serializable {
    private long id;
    private Map<String, IValue> values;

    public MixedEntityValue(long id) {
        this.id = id;
    }

    public MixedEntityValue(IEntityValue entityValue) {
        this.id = entityValue.id();
        entityValue.values().forEach(this::addValue);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public void resetId(long id) {
        this.id = id;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Optional<IValue> getValue(IEntityField field) {
        return Optional.empty();
    }

    @Override
    public Optional<IValue> getValue(String fieldName) {
        return Optional.ofNullable(this.values.get(fieldName));
    }

    @Override
    public Optional<IValue> getValue(long fieldId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IEntityValue addValue(IValue value) {
        this.lazyInit();
        this.values.put(value.getField().name(), value);
        return this;
    }

    @Override
    public Collection<IValue> values() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        return this.values.values();
    }

    @Override
    public IEntityValue addValues(Collection<IValue> values) {
        this.lazyInit();
        values.stream().forEach(v -> this.values.put(v.getField().name(), (IValue)v));
        return this;
    }

    @Override
    public Optional<IValue> remove(IEntityField field) {
        this.lazyInit();
        return Optional.ofNullable(this.values.remove(field.name()));
    }

    @Override
    public void filter(Predicate<? super IValue> predicate) {
        this.values.entrySet().removeIf(entry -> !predicate.test((IValue)entry.getValue()));
    }

    @Override
    public IEntityValue clear() {
        if (this.values != null) {
            this.values.clear();
        }
        return this;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void squeezeEmpty() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EntityValue cloneValue = new EntityValue(this.id);
        cloneValue.addValues(this.values());
        return cloneValue;
    }

    private void lazyInit() {
        if (this.values == null) {
            this.values = new LinkedHashMap<String, IValue>();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MixedEntityValue)) {
            return false;
        }
        MixedEntityValue that = (MixedEntityValue)o;
        return this.id == that.id && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.values);
    }

    public String toString() {
        return "MixedEntityValue{id=" + this.id + ", values=" + (this.values != null ? this.values.toString() : "NULL") + '}';
    }
}

