package com.xforceplus.ultraman.metadata.cdc;

import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by justin.xu on 05/2023.
 *
 * @since 1.8
 */
public class OqsEngineEntity implements Cloneable {
    private boolean deleted;
    private int version;
    private long id;
    private long updateTime;

    private long father;

    // 实例原始属性.
    private Map<String, Object> attributes;

    private EntityClassRef entityClassRef;

    /**
     * 实例.
     */
    public OqsEngineEntity() {
        father = 0;
        deleted = false;
        version = 0;
        id = 0;
        updateTime = 0;
    }

    public long getFather() {
        return father;
    }

    public void setFather(long father) {
        this.father = father;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public int getVersion() {
        return version;
    }


    public long getId() {
        return id;
    }


    public long getUpdateTime() {
        return updateTime;
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }


    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public int attributeSize() {
        return this.attributes.size();
    }

    public EntityClassRef getEntityClassRef() {
        return entityClassRef;
    }

    public void setEntityClassRef(EntityClassRef entityClassRef) {
        this.entityClassRef = entityClassRef;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OqsEngineEntity that = (OqsEngineEntity) o;
        return deleted == that.deleted
            && version == that.version
            && id == that.id
            && updateTime == that.updateTime
            && Objects.equals(attributes, that.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deleted, version, id, updateTime, attributes);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("OriginalEntity{");
        sb.append("deleted=").append(deleted);
        sb.append(", version=").append(version);
        sb.append(", id=").append(id);
        sb.append(", updateTime=").append(updateTime);
        sb.append(", attributes=").append(attributes);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return OqsEngineEntity.Builder.anOriginalEntity()
            .withId(id)
            .withAttributes(new HashMap<>(attributes))
            .withDeleted(deleted)
            .withUpdateTime(updateTime)
            .withVersion(version);
    }


    /**
     * 构造器.
     */
    public static final class Builder {
        private boolean deleted;
        private long father;
        private int version;
        private long id;
        private long updateTime;
        private Map<String, Object> attributes = Collections.emptyMap();
        private EntityClassRef entityClassRef;

        public static Builder anOriginalEntity() {
            return new Builder();
        }

        public Builder withDeleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withFather(long father) {
            this.father = father;
            return this;
        }

        public Builder withUpdateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder withEntityClassRef(EntityClassRef entityClassRef) {
            this.entityClassRef = entityClassRef;
            return this;
        }

        /**
         * 属性集合.
         */
        public Builder withAttributes(Map<String, Object> attributes) {
            if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
                this.attributes = new HashMap<>();
            }
            this.attributes.putAll(attributes);
            return this;
        }

        /**
         * 属性.
         */
        public Builder withAttribute(String key, Object value) {
            if (Collections.emptyMap().getClass().equals(this.attributes.getClass())) {
                this.attributes = new HashMap<>();
            }
            this.attributes.put(key, value);
            return this;
        }

        /**
         * 构造实例.
         */
        public OqsEngineEntity build() {
            OqsEngineEntity oqsEngineEntity = new OqsEngineEntity();
            oqsEngineEntity.deleted = this.deleted;
            oqsEngineEntity.updateTime = this.updateTime;
            oqsEngineEntity.id = this.id;
            oqsEngineEntity.version = this.version;
            oqsEngineEntity.entityClassRef = this.entityClassRef;
            oqsEngineEntity.father = this.father;

            /*
            分离附件和字段属性
             */
            oqsEngineEntity.attributes = this.attributes;

            return oqsEngineEntity;
        }
    }
}
