package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;

/**
 * 空值表示,分为含有附件和不含有附件将解读为不同的意义.<br>
 * 不含附件:
 * <ul>
 *     <li>创建时忽略</li>
 *     <li>更新时删除已有</li>
 * </ul>
 * 含有附件:
 * <ul>
 *     <li>只创建附件</li>
 *     <li>只更新附件</li>
 * </ul>
 * 删除时是忽略字段处理,所以不会影响.
 */
public class EmptyTypedValue extends AbstractValue {

    public EmptyTypedValue(IEntityField field) {
        super(field, ValueWithEmpty.EMPTY_VALUE);
    }

    public EmptyTypedValue(IEntityField field, Attachment attachment) {
        super(field, ValueWithEmpty.EMPTY_VALUE, attachment);
    }

    public EmptyTypedValue(IEntityField field, String attachment) {
        super(field, ValueWithEmpty.EMPTY_VALUE, attachment);

    }

    public EmptyTypedValue(IEntityField field, Object value, String attachemnt) {
        super(field, value, attachemnt);
    }

    @Override
    Object fromString(String value) {
        return ValueWithEmpty.EMPTY_VALUE;
    }

    @Override
    public long valueToLong() {
        return 0;
    }

    @Override
    public Object storageValue() {
        return null;
    }

    @Override
    protected IValue doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new EmptyTypedValue(newField, attachment);
    }

    @Override
    protected IValue doCopy(Object value) {
        return this;
    }

    @Override
    protected boolean skipTypeCheckWithCopy() {
        return true;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}
