/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.values.verifier;

import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.EmptyTypedValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import com.xforceplus.ultraman.metadata.values.verifier.VerifierResult;

public interface ValueVerifier {
    default public VerifierResult verify(IEntityField field, IValue value) {
        if (!this.isRequired(field, value)) {
            return VerifierResult.REQUIRED;
        }
        if (value != null && !EmptyTypedValue.class.isInstance(value)) {
            if (!this.isTooLong(field, value)) {
                return VerifierResult.TOO_LONG;
            }
            if (!this.isHighPrecision(field, value)) {
                return VerifierResult.HIGH_PRECISION;
            }
        }
        return VerifierResult.OK;
    }

    default public boolean isRequired(IEntityField field, IValue value) {
        FieldConfig config = field.config();
        return !config.isRequired() || value != null && !EmptyTypedValue.class.isInstance(value);
    }

    default public boolean isTooLong(IEntityField field, IValue value) {
        return true;
    }

    default public boolean isHighPrecision(IEntityField field, IValue value) {
        return true;
    }
}

