package com.xforceplus.ultraman.oqsengine.data.om.config;

import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.configuration.GatewayUrlSupplier;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.configuration.MessageAppIdSupplier;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.configuration.MessageTokenSupplier;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.configuration.StorageAppIdSupplier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 8/28/2020 12:28 PM
 * @description:
 * @history:
 */
@Configuration
public class MessageListenerConfiguration {

    @Value("${xplat.tenant.security.app-id:50}")
    private Long appId;
    @Value("${xplat.tenant.security.url:http://paas-t.xforceplus.com}")
    private String url;
    @Value("${tower.userCenter.url:http://paas-t.xforceplus.com/api/client/login}")
    private String loginUrl;
    @Value("${tower.userCenter.clientId:message_center_fat}")
    private String clientId;
    @Value("${tower.userCenter.secret:1hgrttyrew32}")
    private String secret;

    @Bean
    public GetTokenEverytime tokenEverytime(RestTemplate restTemplate){
        return new GetTokenEverytime(loginUrl, clientId, secret, restTemplate);
    }

    @Bean
    public MessageTokenSupplier messageTokenSupplier(GetTokenEverytime tokenSupplier) {
        return tokenSupplier::getToken;
    }

    @Bean
    public MessageAppIdSupplier messageAppIdSupplier(){
        return () -> Long.toString(appId);
    }

    @Bean
    public GatewayUrlSupplier gateway(){
        return () -> url;
    }

    @Bean
    public StorageAppIdSupplier supplier(){
        return () -> Long.toString(appId);
    }
}
