/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.datasource;

import com.xforceplus.ultraman.oqsengine.plus.common.datasource.log.LoggerDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import javax.sql.DataSource;

public class DataSourcePackage {
    private static final int MASTER_DATASOURCE_INDEX = 0;
    private List<DataSource> master;
    private List<DataSource> indexWriter;
    private List<DataSource> indexSearch;

    public DataSourcePackage(List<DataSource> master) {
        this(master, null, null);
    }

    public DataSourcePackage(List<DataSource> master, List<DataSource> indexWriter, List<DataSource> indexSearch) {
        this.master = master;
        this.indexWriter = indexWriter;
        this.indexSearch = indexSearch;
    }

    public List<DataSource> getMaster() {
        return this.master;
    }

    public DataSource getFirstMaster() {
        return this.master.get(0);
    }

    public List<DataSource> getIndexWriter() {
        return this.indexWriter;
    }

    public List<DataSource> getIndexSearch() {
        return this.indexSearch;
    }

    public DataSource getDevOps() {
        return this.getFirstMaster();
    }

    public DataSource getChangelog() {
        return this.getFirstMaster();
    }

    public DataSource getSegment() {
        return this.getFirstMaster();
    }

    public DataSource getMeta() {
        return this.getFirstMaster();
    }

    public void close() {
        if (this.master != null) {
            this.doClose(this.master);
        }
        if (this.indexWriter != null) {
            this.doClose(this.indexWriter);
        }
        if (this.indexSearch != null) {
            this.doClose(this.indexSearch);
        }
    }

    private void doClose(List<DataSource> master) {
        DataSource d = null;
        for (DataSource ds : master) {
            if (LoggerDataSource.class.isInstance(ds)) {
                d = ((LoggerDataSource)ds).getDelegate();
            }
            if (!HikariDataSource.class.isInstance(d)) continue;
            ((HikariDataSource)d).close();
        }
    }
}

