/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.mock;

import com.xforceplus.ultraman.oqsengine.plus.common.datasource.DataSourceFactory;
import com.xforceplus.ultraman.oqsengine.plus.common.datasource.DataSourcePackage;
import com.xforceplus.ultraman.oqsengine.plus.common.mock.BeanInitialization;
import com.xforceplus.ultraman.oqsengine.plus.common.mock.InitializationHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CommonInitialization
implements BeanInitialization {
    private static volatile CommonInitialization instance = null;
    private DataSourcePackage dataSourcePackage;
    private ExecutorService runner;

    private CommonInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonInitialization getInstance() throws IllegalAccessException {
        if (null != instance) return instance;
        Class<CommonInitialization> clazz = CommonInitialization.class;
        synchronized (CommonInitialization.class) {
            if (null != instance) return instance;
            instance = new CommonInitialization();
            instance.init();
            InitializationHelper.add(instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void init() throws IllegalAccessException {
        this.runner = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024));
    }

    @Override
    public void clear() throws Exception {
        try {
            if (null != this.dataSourcePackage) {
                this.dataSourcePackage.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        if (null != this.dataSourcePackage) {
            this.dataSourcePackage.close();
            this.dataSourcePackage = null;
        }
        this.runner.shutdown();
        this.runner = null;
        instance = null;
    }

    public synchronized DataSourcePackage getDataSourcePackage(boolean showSql) {
        if (null == this.dataSourcePackage) {
            this.dataSourcePackage = DataSourceFactory.build(showSql);
        }
        return this.dataSourcePackage;
    }

    public ExecutorService getRunner() {
        return this.runner;
    }
}

