package com.xforceplus.ultraman.oqsengine.plus.common.iterator.searchafter;

import com.xforceplus.ultraman.oqsengine.plus.common.iterator.AbstractDataIterator;
import java.util.List;
import java.util.function.BiFunction;

/**
 * search after的迭代器实现.
 * 偏移只能使用兼容long的类型.
 *
 * @author dongbin
 * @version 0.1 2022/5/23 18:57
 * @since 1.8
 */
public class SearchAfterDataIterator<E> extends AbstractDataIterator<E> {

    /*
    表示是否损坏.true表示损坏.
     */
    private boolean corrupted = false;
    /*
    是否第一次开始,true是,false不是.
     */
    private boolean first = true;
    /*
    迭代顺序,true升序,false降序.
     */
    private boolean asc;
    /*
    偏移量.
     */
    private long offset;
    /*
    数据加载方法.
     */
    private BiFunction<List<E>, SearchAfterLoadInfo, Long> load;

    public SearchAfterDataIterator(BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        this(AbstractDataIterator.DEFAULT_BUFF_SIZE, load);
    }

    public SearchAfterDataIterator(boolean asc, BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        this(AbstractDataIterator.DEFAULT_BUFF_SIZE, asc, load);
    }

    public SearchAfterDataIterator(int buffSize, BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        this(buffSize, true, load);
    }

    /**
     * 构造一个searchAfter的迭代器.
     *
     * @param buffSize 缓冲大小.
     * @param asc true 升序, false 降序.
     * @param load 加载器.
     */
    public SearchAfterDataIterator(int buffSize, boolean asc, BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        super(buffSize, Long.MAX_VALUE);
        this.load = load;
        this.asc = asc;
    }

    public long getCurrentOffset() {
        return offset;
    }

    @Override
    public boolean hasNext() {
        if (corrupted) {
            throw new IllegalStateException("The current iterator is corrupted.");
        } else {
            return super.hasNext();
        }
    }

    @Override
    public E next() {
        if (corrupted) {
            throw new IllegalStateException("The current iterator is corrupted.");
        } else {
            return super.next();
        }
    }

    @Override
    protected void load(List<E> buff, int limit) throws Exception {
        long newOffset = load.apply(buff, new SearchAfterLoadInfo(limit, this.offset, this.asc, this.first));

        if (asc) {
            if (!this.first && this.offset >= newOffset && !buff.isEmpty()) {
                this.corrupted = true;
                throw new IllegalStateException(
                    String.format(
                        "Currently in ascending mode, the new offset is not greater than the current offset.[%d, %d]",
                        this.offset, newOffset
                        )
                );
            }

        } else {

            if (!this.first && this.offset <= newOffset && !buff.isEmpty()) {
                this.corrupted = true;
                throw new IllegalStateException(
                    String.format(
                        "Currently in descending mode, the new offset is not less than the current offset.[%d, %d]",
                        this.offset, newOffset
                    )
                );
            }

        }

        this.first = false;

        this.offset = newOffset;
    }

}
