package com.xforceplus.ultraman.oqsengine.plus.common.mock;

import static com.xforceplus.ultraman.oqsengine.plus.common.mock.EnvMockConstant.RUNNER_CORE_POOL_MAX_SIZE;
import static com.xforceplus.ultraman.oqsengine.plus.common.mock.EnvMockConstant.RUNNER_CORE_POOL_SIZE;
import static com.xforceplus.ultraman.oqsengine.plus.common.mock.EnvMockConstant.RUNNER_DEQUE_CAPACITY;

import com.xforceplus.ultraman.oqsengine.plus.common.datasource.DataSourceFactory;
import com.xforceplus.ultraman.oqsengine.plus.common.datasource.DataSourcePackage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Created by justin.xu on 06/2021.
 *
 * @since 1.8
 */
public class CommonInitialization implements BeanInitialization {

    private static volatile CommonInitialization instance = null;

    private DataSourcePackage dataSourcePackage;
    private ExecutorService runner;

    private CommonInitialization() {

    }

    /**
     * 获取单例.
     */
    public static CommonInitialization getInstance() throws IllegalAccessException {
        if (null == instance) {
            synchronized (CommonInitialization.class) {
                if (null == instance) {
                    instance = new CommonInitialization();
                    instance.init();
                    InitializationHelper.add(instance);
                }
            }
        }
        return instance;
    }

    @Override
    public void init() throws IllegalAccessException {
        runner = new ThreadPoolExecutor(RUNNER_CORE_POOL_SIZE, RUNNER_CORE_POOL_MAX_SIZE, 0,
            TimeUnit.SECONDS, new LinkedBlockingDeque<>(RUNNER_DEQUE_CAPACITY));
    }

    @Override
    public void clear() throws Exception {
        try {
            if (null != dataSourcePackage) {
                dataSourcePackage.close();
            }
        } catch (Exception e) {
            //  ignore
        }
    }

    @Override
    public void destroy() {
        if (null != dataSourcePackage) {
            dataSourcePackage.close();
            dataSourcePackage = null;
        }

        runner.shutdown();
        runner = null;

        instance = null;
    }

    /**
     * get datasourcePackage with lazy init.
     */
    public synchronized DataSourcePackage getDataSourcePackage(boolean showSql) {
        if (null == dataSourcePackage) {
            dataSourcePackage = DataSourceFactory.build(showSql);
        }
        return dataSourcePackage;
    }

    public ExecutorService getRunner() {
        return runner;
    }
}
