/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.serializable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.xforceplus.ultraman.oqsengine.plus.common.serializable.CanNotBeSerializedException;
import com.xforceplus.ultraman.oqsengine.plus.common.serializable.CanNotBeUnSerializedException;
import com.xforceplus.ultraman.oqsengine.plus.common.serializable.SerializeStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class KryoSerializeStrategy
implements SerializeStrategy {
    private Kryo kryo = new Kryo();

    public KryoSerializeStrategy() {
        this.kryo.setRegistrationRequired(false);
    }

    public void registerClass(Class clazz, int id) {
        if (id < 1) {
            throw new IllegalArgumentException("It has to be greater than 0.");
        }
        this.kryo.register(clazz, id);
    }

    @Override
    public byte[] serialize(Serializable source) throws CanNotBeSerializedException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try (Output output = new Output((OutputStream)buff);){
            try {
                this.kryo.writeObject(output, (Object)source);
            }
            catch (Exception ex) {
                throw new CanNotBeSerializedException(ex.getMessage(), ex);
            }
        }
        return buff.toByteArray();
    }

    @Override
    public <T> T unserialize(byte[] datas, Class<T> clazz) throws CanNotBeUnSerializedException {
        Throwable throwable = null;
        try (Input input = new Input((InputStream)new ByteArrayInputStream(datas));){
            Object object = this.kryo.readObject(input, clazz);
            return (T)object;
        }
        catch (Exception ex) {
            try {
                throw new CanNotBeUnSerializedException(ex.getMessage(), ex);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

