/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.iterator.searchafter;

import com.xforceplus.ultraman.oqsengine.plus.common.iterator.AbstractDataIterator;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.searchafter.SearchAfterLoadInfo;
import java.util.List;
import java.util.function.BiFunction;

public class SearchAfterDataIterator<E>
extends AbstractDataIterator<E> {
    private boolean corrupted = false;
    private boolean first = true;
    private boolean asc;
    private long offset;
    private BiFunction<List<E>, SearchAfterLoadInfo, Long> load;

    public SearchAfterDataIterator(BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        this(3000, load);
    }

    public SearchAfterDataIterator(boolean asc, BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        this(3000, asc, load);
    }

    public SearchAfterDataIterator(int buffSize, BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        this(buffSize, true, load);
    }

    public SearchAfterDataIterator(int buffSize, boolean asc, BiFunction<List<E>, SearchAfterLoadInfo, Long> load) {
        super(buffSize, Long.MAX_VALUE);
        this.load = load;
        this.asc = asc;
    }

    public long getCurrentOffset() {
        return this.offset;
    }

    @Override
    public boolean hasNext() {
        if (this.corrupted) {
            throw new IllegalStateException("The current iterator is corrupted.");
        }
        return super.hasNext();
    }

    @Override
    public E next() {
        if (this.corrupted) {
            throw new IllegalStateException("The current iterator is corrupted.");
        }
        return super.next();
    }

    @Override
    protected void load(List<E> buff, int limit) throws Exception {
        long newOffset = this.load.apply(buff, new SearchAfterLoadInfo(limit, this.offset, this.asc, this.first));
        if (this.asc) {
            if (!this.first && this.offset >= newOffset && !buff.isEmpty()) {
                this.corrupted = true;
                throw new IllegalStateException(String.format("Currently in ascending mode, the new offset is not greater than the current offset.[%d, %d]", this.offset, newOffset));
            }
        } else if (!this.first && this.offset <= newOffset && !buff.isEmpty()) {
            this.corrupted = true;
            throw new IllegalStateException(String.format("Currently in descending mode, the new offset is not less than the current offset.[%d, %d]", this.offset, newOffset));
        }
        this.first = false;
        this.offset = newOffset;
    }
}

