/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.jdbc;

import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.Arrays;
import java.util.Optional;

public class TypesUtils {
    private static TypeHolder[] holders = (TypeHolder[])Arrays.stream(Types.class.getFields()).filter(f -> Integer.TYPE.equals(f.getType())).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> Modifier.isPublic(f.getModifiers())).map(f -> {
        try {
            return new TypeHolder(f.getInt(null), f.getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }).sorted().toArray(TypeHolder[]::new);

    public static Optional<String> name(int value) {
        TypeHolder holder = new TypeHolder(value, null);
        int index = Arrays.binarySearch(holders, holder);
        if (index > -1) {
            return Optional.ofNullable(holders[index].getName());
        }
        return Optional.empty();
    }

    private static class TypeHolder
    implements Comparable<TypeHolder> {
        private int value;
        private String name;

        public TypeHolder(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(TypeHolder o) {
            if (this.value < o.value) {
                return -1;
            }
            if (this.value > o.value) {
                return 1;
            }
            return 0;
        }
    }
}

