/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.iterator;

import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDataIterator<E>
implements DataIterator<E> {
    public static final int DEFAULT_BUFF_SIZE = 3000;
    private int buffSize;
    private List<E> buff;
    private long maxSize;
    private long cursor;
    private boolean more;

    public AbstractDataIterator() {
        this(3000);
    }

    public AbstractDataIterator(int buffSize) {
        this(buffSize, Long.MAX_VALUE);
    }

    public AbstractDataIterator(int buffSize, long maxSize) {
        this.buff = buffSize > 0 ? new ArrayList(buffSize) : Collections.emptyList();
        this.buffSize = buffSize;
        this.maxSize = maxSize;
        this.cursor = 0L;
        this.more = true;
    }

    @Override
    public long size() {
        return 0L;
    }

    public long getCursor() {
        return this.cursor;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getBuffSize() {
        return this.buffSize;
    }

    @Override
    public boolean hasNext() {
        if (this.haveOutOfLimit()) {
            return false;
        }
        if (this.buff.isEmpty()) {
            if (!this.more) {
                return false;
            }
            try {
                this.load(this.buff, this.getBuffSize());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.more = this.buff.size() >= this.getBuffSize();
        }
        return !this.buff.isEmpty();
    }

    @Override
    public E next() {
        if (this.haveOutOfLimit()) {
            return null;
        }
        E e = this.buff.remove(0);
        ++this.cursor;
        return e;
    }

    public boolean more() {
        return this.more;
    }

    protected abstract void load(List<E> var1, int var2) throws Exception;

    private boolean haveOutOfLimit() {
        return this.cursor >= this.maxSize;
    }
}

