/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ByteUtil {
    private static final byte[] BUILD_BYTE_TABLE = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};

    private ByteUtil() {
    }

    public static byte[] shortToByte(short number) {
        byte[] b = new byte[2];
        for (int i = 1; i >= 0; --i) {
            b[i] = (byte)(number % 256);
            number = (short)(number >> 8);
        }
        return b;
    }

    public static short byteToShort(byte[] b) {
        return ByteUtil.byteToShort(b, 0);
    }

    public static short byteToShort(byte[] b, int start) {
        return (short)((b[start] & 0xFF) << 8 | b[start + 1] & 0xFF);
    }

    public static byte[] intToByte(int number) {
        byte[] b = new byte[4];
        for (int i = 3; i >= 0; --i) {
            b[i] = (byte)(number % 256);
            number >>= 8;
        }
        return b;
    }

    public static int byteToInt(byte[] b) {
        return ByteUtil.byteToInt(b, 0);
    }

    public static int byteToInt(byte[] b, int start) {
        return (b[start] & 0xFF) << 24 | (b[start + 1] & 0xFF) << 16 | (b[start + 2] & 0xFF) << 8 | b[start + 3] & 0xFF;
    }

    public static byte[] longToByte(long number) {
        byte[] b = new byte[8];
        for (int i = 7; i >= 0; --i) {
            b[i] = (byte)(number % 256L);
            number >>= 8;
        }
        return b;
    }

    public static long byteToLong(byte[] b) {
        return ByteUtil.byteToLong(b, 0);
    }

    public static long byteToLong(byte[] b, int start) {
        return ((long)b[start] & 0xFFL) << 56 | ((long)b[start + 1] & 0xFFL) << 48 | ((long)b[start + 2] & 0xFFL) << 40 | ((long)b[start + 3] & 0xFFL) << 32 | ((long)b[start + 4] & 0xFFL) << 24 | ((long)b[start + 5] & 0xFFL) << 16 | ((long)b[start + 6] & 0xFFL) << 8 | (long)b[start + 7] & 0xFFL;
    }

    public static byte[] doubleToByte(double d) {
        byte[] bytes = new byte[8];
        long l = Double.doubleToLongBits(d);
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Long.valueOf(l).byteValue();
            l >>= 8;
        }
        return bytes;
    }

    public static double byteToDouble(byte[] b) {
        return ByteUtil.byteToDouble(b, 0);
    }

    public static double byteToDouble(byte[] b, int start) {
        long l = b[start];
        l &= 0xFFL;
        l |= (long)b[start + 1] << 8;
        l &= 0xFFFFL;
        l |= (long)b[start + 2] << 16;
        l &= 0xFFFFFFL;
        l |= (long)b[start + 3] << 24;
        l &= 0xFFFFFFFFL;
        l |= (long)b[start + 4] << 32;
        l &= 0xFFFFFFFFFFL;
        l |= (long)b[start + 5] << 40;
        l &= 0xFFFFFFFFFFFFL;
        l |= (long)b[start + 6] << 48;
        l &= 0xFFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l |= (long)b[start + 7] << 56);
    }

    public static byte[] floatToByte(float d) {
        byte[] bytes = new byte[4];
        int l = Float.floatToIntBits(d);
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Integer.valueOf(l).byteValue();
            l >>= 8;
        }
        return bytes;
    }

    public static float byteToFloat(byte[] b) {
        return ByteUtil.byteToFloat(b, 0);
    }

    public static float byteToFloat(byte[] b, int start) {
        int l = b[start];
        l &= 0xFF;
        l = (int)((long)l | (long)b[start + 1] << 8);
        l &= 0xFFFF;
        l = (int)((long)l | (long)b[start + 2] << 16);
        l &= 0xFFFFFF;
        l = (int)((long)l | (long)b[start + 3] << 24);
        l = (int)((long)l & 0xFFFFFFFFL);
        return Float.intBitsToFloat(l);
    }

    public static byte[] stringToByte(String s, Charset charset) {
        return s.getBytes(charset);
    }

    public static String byteToString(byte[] b, Charset charset) {
        return new String(b, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByte(Object obj) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        out.writeObject(obj);
        try (ObjectOutputStream out = new ObjectOutputStream(buff);){
            byte[] byArray = buff.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object byteToObject(byte[] b) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buff = new ByteArrayInputStream(b);
        ObjectInputStream in = new ObjectInputStream(buff);
        Object obj = in.readObject();
        try {
            Object object = obj;
            return object;
        }
        finally {
            in.close();
        }
    }

    public static boolean equalsBit(byte a, byte b) {
        return Arrays.equals(ByteUtil.byteToBitArray(a), ByteUtil.byteToBitArray(b));
    }

    public static boolean equalsBit(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        for (int count = 0; count < a.length; ++count) {
            if (ByteUtil.equalsBit(a[count], b[count])) continue;
            return false;
        }
        return true;
    }

    public static String bitsString(byte[] bytes) {
        StringBuilder buff = new StringBuilder();
        for (byte b : bytes) {
            ByteUtil.doBitString(b, buff);
        }
        return buff.toString();
    }

    public static String bitString(byte b) {
        StringBuilder buff = new StringBuilder();
        ByteUtil.doBitString(b, buff);
        return buff.toString();
    }

    public static boolean[] byteToBitArray(byte b) {
        boolean[] buff = new boolean[8];
        int index = 0;
        for (int i = 7; i >= 0; --i) {
            buff[index++] = (b >>> i & 1) == 1;
        }
        return buff;
    }

    public static boolean byteBitValue(byte b, int index) {
        return ByteUtil.byteToBitArray(b)[index];
    }

    public static byte buildNewByte(boolean[] values) {
        byte b = 0;
        for (int i = 0; i < 8; ++i) {
            if (!values[i]) continue;
            b = (byte)(b | BUILD_BYTE_TABLE[i]);
        }
        return b;
    }

    public static byte changeByteBitValue(byte b, int index, boolean newValue) {
        boolean[] bitValues = ByteUtil.byteToBitArray(b);
        bitValues[index] = newValue;
        return ByteUtil.buildNewByte(bitValues);
    }

    private static void doBitString(byte b, StringBuilder buff) {
        boolean[] array = ByteUtil.byteToBitArray(b);
        for (int i = 0; i < array.length; ++i) {
            buff.append(array[i] ? 1 : 0);
        }
    }
}

