package com.xforceplus.ultraman.oqsengine.plus.common.proxy.jdk;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

/**
 * 一个执行选择代理实现.<br>
 * 其会根据设定的方法返回值选择对应序号的实例进行执行.
 *
 * @author dongbin
 * @version 0.1 2022/12/12 13:59
 * @since 1.8
 */
public class InstanceSelectHandler implements InvocationHandler {

    private Supplier<Integer> selectSupplier;

    private Object[] instances;

    private Object defaultTarget;

    /**
     * 构造一个实例选择代理器.
     *
     * @param selectSupplier 选择借给器,给出当前选择的序号下标,从0开始.
     * @param instances      实例列表.
     * @param defaultTarget  默认实例.
     */
    public InstanceSelectHandler(Supplier<Integer> selectSupplier, Object[] instances, Object defaultTarget) {
        this.selectSupplier = selectSupplier;
        this.instances = instances;
        this.defaultTarget = defaultTarget;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int index = selectSupplier.get();
        if (index < 0 || index > instances.length - 1) {
            return invokeMethod(method, this.defaultTarget, args);
        } else {
            return invokeMethod(method, this.instances[index], args);
        }
    }

    private Object invokeMethod(Method method, Object instance, Object[] args)
        throws InvocationTargetException, IllegalAccessException {
        return method.invoke(instance, args);
    }
}
