/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.common.datasource;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.xforceplus.ultraman.oqsengine.plus.common.datasource.log.LoggerDataSource;
import com.xforceplus.ultraman.sdk.core.datasource.PackageInternal;
import com.xforceplus.ultraman.sdk.core.datasource.SupportClientType;
import com.xforceplus.ultraman.sdk.core.datasource.resolver.DataConfigResolver;
import com.xforceplus.ultraman.sdk.infra.base.thread.ExecutorHelper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.Metrics;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;

public class MasterResolver
implements DataConfigResolver {
    public Tuple2<String, PackageInternal> resolve(Config config, boolean showSql) {
        Object anyRef = config.getAnyRef("dataSources");
        if (anyRef instanceof List) {
            List configList = config.getConfigList("dataSources");
            if (((List)anyRef).isEmpty()) {
                throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
            }
            PackageInternal masterPackageInternal = null;
            masterPackageInternal = MasterResolver.buildDataSources(configList, showSql);
            return Tuple.of((Object)"master", (Object)masterPackageInternal);
        }
        ConfigObject configObject = config.getObject("dataSources");
        if (configObject.isEmpty()) {
            throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        PackageInternal masterPackageInternal = null;
        if (config.hasPath(SupportClientType.MASTER_DB.getPath())) {
            masterPackageInternal = MasterResolver.buildDataSources(config.getConfigList(SupportClientType.MASTER_DB.getPath()), showSql);
            return Tuple.of((Object)"master", (Object)masterPackageInternal);
        }
        throw new RuntimeException("No Master datasource config");
    }

    private static PackageInternal buildDataSources(List<? extends Config> configs, boolean showSql) {
        LinkedHashMap<String, Closeable> ds = new LinkedHashMap<String, Closeable>(configs.size());
        String name = SupportClientType.MASTER_DB.getName() + "-" + 0;
        Closeable first = null;
        for (int i = 0; i < configs.size(); ++i) {
            String dsName = SupportClientType.MASTER_DB.getName() + "-" + i;
            Closeable dataSource = MasterResolver.buildDataSource(dsName, configs.get(i), showSql);
            if (i == 0) {
                first = dataSource;
            }
            ds.put(dsName, dataSource);
        }
        return new PackageInternal(name, first, ds);
    }

    private static Closeable buildDataSource(String name, Config config, boolean showSql) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        hikariConfig.setPoolName(name);
        hikariConfig.setMetricRegistry((Object)Metrics.globalRegistry);
        config.entrySet().stream().forEach(e -> {
            try {
                MasterResolver.invokeMethod(hikariConfig, (String)e.getKey(), (ConfigValue)e.getValue());
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Configuration error, wrong property '%s' '%s'.", e.getKey(), e.getValue()));
            }
        });
        hikariConfig.setThreadFactory(ExecutorHelper.buildNameThreadFactory((String)"jdbc-pool", (boolean)false));
        if (showSql) {
            return new LoggerDataSource((DataSource)new HikariDataSource(hikariConfig));
        }
        return new HikariDataSource(hikariConfig);
    }

    private static void invokeMethod(HikariConfig hikariConfig, String attrName, ConfigValue value) throws Exception {
        Class<?> clazz = hikariConfig.getClass();
        String methodName = "set" + attrName.toUpperCase(Locale.US).substring(0, 1) + attrName.substring(1);
        Method method = null;
        switch (value.valueType()) {
            case NUMBER: {
                try {
                    method = clazz.getMethod(methodName, Long.TYPE);
                }
                catch (NoSuchMethodException ex) {
                    method = clazz.getMethod(methodName, Integer.TYPE);
                }
                break;
            }
            case STRING: {
                method = clazz.getMethod(methodName, String.class);
                break;
            }
            case BOOLEAN: {
                method = clazz.getMethod(methodName, Boolean.TYPE);
                break;
            }
            default: {
                throw new NoSuchMethodException(String.format("The '%s' property setting could not be found.", attrName));
            }
        }
        method.invoke((Object)hikariConfig, value.unwrapped());
    }
}

